package zio.aws.sms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServerValidationOutput(
    server: Optional[zio.aws.sms.model.Server] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.ServerValidationOutput = {
    import ServerValidationOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.ServerValidationOutput
      .builder()
      .optionallyWith(server.map(value => value.buildAwsValue()))(_.server)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.ServerValidationOutput.ReadOnly =
    zio.aws.sms.model.ServerValidationOutput.wrap(buildAwsValue())
}
object ServerValidationOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.ServerValidationOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.ServerValidationOutput = zio.aws.sms.model
      .ServerValidationOutput(server.map(value => value.asEditable))
    def server: Optional[zio.aws.sms.model.Server.ReadOnly]
    def getServer: ZIO[Any, AwsError, zio.aws.sms.model.Server.ReadOnly] =
      AwsError.unwrapOptionField("server", server)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.ServerValidationOutput
  ) extends zio.aws.sms.model.ServerValidationOutput.ReadOnly {
    override val server: Optional[zio.aws.sms.model.Server.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.server())
        .map(value => zio.aws.sms.model.Server.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.ServerValidationOutput
  ): zio.aws.sms.model.ServerValidationOutput.ReadOnly = new Wrapper(impl)
}
