package zio.aws.sms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Source(
    s3Location: Optional[zio.aws.sms.model.S3Location] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.sms.model.Source = {
    import Source.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.Source
      .builder()
      .optionallyWith(s3Location.map(value => value.buildAwsValue()))(
        _.s3Location
      )
      .build()
  }
  def asReadOnly: zio.aws.sms.model.Source.ReadOnly =
    zio.aws.sms.model.Source.wrap(buildAwsValue())
}
object Source {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sms.model.Source] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.Source =
      zio.aws.sms.model.Source(s3Location.map(value => value.asEditable))
    def s3Location: Optional[zio.aws.sms.model.S3Location.ReadOnly]
    def getS3Location
        : ZIO[Any, AwsError, zio.aws.sms.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("s3Location", s3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.Source
  ) extends zio.aws.sms.model.Source.ReadOnly {
    override val s3Location: Optional[zio.aws.sms.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Location())
        .map(value => zio.aws.sms.model.S3Location.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.Source
  ): zio.aws.sms.model.Source.ReadOnly = new Wrapper(impl)
}
