package zio.aws.sms.model
import zio.aws.sms.model.primitives.{Description, AppId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartOnDemandAppReplicationRequest(
    appId: AppId,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.StartOnDemandAppReplicationRequest = {
    import StartOnDemandAppReplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.StartOnDemandAppReplicationRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.sms.model.StartOnDemandAppReplicationRequest.ReadOnly =
    zio.aws.sms.model.StartOnDemandAppReplicationRequest.wrap(buildAwsValue())
}
object StartOnDemandAppReplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.StartOnDemandAppReplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.StartOnDemandAppReplicationRequest =
      zio.aws.sms.model.StartOnDemandAppReplicationRequest(
        appId,
        description.map(value => value)
      )
    def appId: AppId
    def description: Optional[Description]
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.StartOnDemandAppReplicationRequest
  ) extends zio.aws.sms.model.StartOnDemandAppReplicationRequest.ReadOnly {
    override val appId: AppId = zio.aws.sms.model.primitives.AppId(impl.appId())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.sms.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.StartOnDemandAppReplicationRequest
  ): zio.aws.sms.model.StartOnDemandAppReplicationRequest.ReadOnly =
    new Wrapper(impl)
}
