package zio.aws.sms.model
import zio.aws.sms.model.primitives.{Description, ReplicationJobId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartOnDemandReplicationRunRequest(
    replicationJobId: ReplicationJobId,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.StartOnDemandReplicationRunRequest = {
    import StartOnDemandReplicationRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.StartOnDemandReplicationRunRequest
      .builder()
      .replicationJobId(
        ReplicationJobId.unwrap(replicationJobId): java.lang.String
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.sms.model.StartOnDemandReplicationRunRequest.ReadOnly =
    zio.aws.sms.model.StartOnDemandReplicationRunRequest.wrap(buildAwsValue())
}
object StartOnDemandReplicationRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.StartOnDemandReplicationRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.StartOnDemandReplicationRunRequest =
      zio.aws.sms.model.StartOnDemandReplicationRunRequest(
        replicationJobId,
        description.map(value => value)
      )
    def replicationJobId: ReplicationJobId
    def description: Optional[Description]
    def getReplicationJobId: ZIO[Any, Nothing, ReplicationJobId] =
      ZIO.succeed(replicationJobId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.StartOnDemandReplicationRunRequest
  ) extends zio.aws.sms.model.StartOnDemandReplicationRunRequest.ReadOnly {
    override val replicationJobId: ReplicationJobId =
      zio.aws.sms.model.primitives.ReplicationJobId(impl.replicationJobId())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.sms.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.StartOnDemandReplicationRunRequest
  ): zio.aws.sms.model.StartOnDemandReplicationRunRequest.ReadOnly =
    new Wrapper(impl)
}
