package zio.aws.sms.model
import zio.aws.sms.model.primitives.AppId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopAppReplicationRequest(
    appId: Optional[AppId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.StopAppReplicationRequest = {
    import StopAppReplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.StopAppReplicationRequest
      .builder()
      .optionallyWith(
        appId.map(value => AppId.unwrap(value): java.lang.String)
      )(_.appId)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.StopAppReplicationRequest.ReadOnly =
    zio.aws.sms.model.StopAppReplicationRequest.wrap(buildAwsValue())
}
object StopAppReplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.StopAppReplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.StopAppReplicationRequest =
      zio.aws.sms.model.StopAppReplicationRequest(appId.map(value => value))
    def appId: Optional[AppId]
    def getAppId: ZIO[Any, AwsError, AppId] =
      AwsError.unwrapOptionField("appId", appId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.StopAppReplicationRequest
  ) extends zio.aws.sms.model.StopAppReplicationRequest.ReadOnly {
    override val appId: Optional[AppId] = zio.aws.core.internal
      .optionalFromNullable(impl.appId())
      .map(value => zio.aws.sms.model.primitives.AppId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.StopAppReplicationRequest
  ): zio.aws.sms.model.StopAppReplicationRequest.ReadOnly = new Wrapper(impl)
}
