package zio.aws.sms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserData(
    s3Location: Optional[zio.aws.sms.model.S3Location] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.sms.model.UserData = {
    import UserData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.UserData
      .builder()
      .optionallyWith(s3Location.map(value => value.buildAwsValue()))(
        _.s3Location
      )
      .build()
  }
  def asReadOnly: zio.aws.sms.model.UserData.ReadOnly =
    zio.aws.sms.model.UserData.wrap(buildAwsValue())
}
object UserData {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sms.model.UserData] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.UserData =
      zio.aws.sms.model.UserData(s3Location.map(value => value.asEditable))
    def s3Location: Optional[zio.aws.sms.model.S3Location.ReadOnly]
    def getS3Location
        : ZIO[Any, AwsError, zio.aws.sms.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("s3Location", s3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.UserData
  ) extends zio.aws.sms.model.UserData.ReadOnly {
    override val s3Location: Optional[zio.aws.sms.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Location())
        .map(value => zio.aws.sms.model.S3Location.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.UserData
  ): zio.aws.sms.model.UserData.ReadOnly = new Wrapper(impl)
}
