package zio.aws.sms.model
import scala.jdk.CollectionConverters._
sealed trait ValidationStatus {
  def unwrap: software.amazon.awssdk.services.sms.model.ValidationStatus
}
object ValidationStatus {
  def wrap(
      value: software.amazon.awssdk.services.sms.model.ValidationStatus
  ): zio.aws.sms.model.ValidationStatus = value match {
    case software.amazon.awssdk.services.sms.model.ValidationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sms.model.ValidationStatus.READY_FOR_VALIDATION =>
      val r = READY_FOR_VALIDATION
      r
    case software.amazon.awssdk.services.sms.model.ValidationStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.sms.model.ValidationStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.sms.model.ValidationStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.sms.model.ValidationStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.sms.model.ValidationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ValidationStatus =
      software.amazon.awssdk.services.sms.model.ValidationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object READY_FOR_VALIDATION extends zio.aws.sms.model.ValidationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ValidationStatus =
      software.amazon.awssdk.services.sms.model.ValidationStatus.READY_FOR_VALIDATION
  }
  case object PENDING extends zio.aws.sms.model.ValidationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ValidationStatus =
      software.amazon.awssdk.services.sms.model.ValidationStatus.PENDING
  }
  case object IN_PROGRESS extends zio.aws.sms.model.ValidationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ValidationStatus =
      software.amazon.awssdk.services.sms.model.ValidationStatus.IN_PROGRESS
  }
  case object SUCCEEDED extends zio.aws.sms.model.ValidationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ValidationStatus =
      software.amazon.awssdk.services.sms.model.ValidationStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.sms.model.ValidationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ValidationStatus =
      software.amazon.awssdk.services.sms.model.ValidationStatus.FAILED
  }
}
