package zio.aws.sms.model
import zio.aws.sms.model.primitives.{VmPath, VmManagerName, VmName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VmServer(
    vmServerAddress: Optional[zio.aws.sms.model.VmServerAddress] =
      Optional.Absent,
    vmName: Optional[VmName] = Optional.Absent,
    vmManagerName: Optional[VmManagerName] = Optional.Absent,
    vmManagerType: Optional[zio.aws.sms.model.VmManagerType] = Optional.Absent,
    vmPath: Optional[VmPath] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.sms.model.VmServer = {
    import VmServer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.VmServer
      .builder()
      .optionallyWith(vmServerAddress.map(value => value.buildAwsValue()))(
        _.vmServerAddress
      )
      .optionallyWith(
        vmName.map(value => VmName.unwrap(value): java.lang.String)
      )(_.vmName)
      .optionallyWith(
        vmManagerName.map(value =>
          VmManagerName.unwrap(value): java.lang.String
        )
      )(_.vmManagerName)
      .optionallyWith(vmManagerType.map(value => value.unwrap))(_.vmManagerType)
      .optionallyWith(
        vmPath.map(value => VmPath.unwrap(value): java.lang.String)
      )(_.vmPath)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.VmServer.ReadOnly =
    zio.aws.sms.model.VmServer.wrap(buildAwsValue())
}
object VmServer {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sms.model.VmServer] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.VmServer = zio.aws.sms.model.VmServer(
      vmServerAddress.map(value => value.asEditable),
      vmName.map(value => value),
      vmManagerName.map(value => value),
      vmManagerType.map(value => value),
      vmPath.map(value => value)
    )
    def vmServerAddress: Optional[zio.aws.sms.model.VmServerAddress.ReadOnly]
    def vmName: Optional[VmName]
    def vmManagerName: Optional[VmManagerName]
    def vmManagerType: Optional[zio.aws.sms.model.VmManagerType]
    def vmPath: Optional[VmPath]
    def getVmServerAddress
        : ZIO[Any, AwsError, zio.aws.sms.model.VmServerAddress.ReadOnly] =
      AwsError.unwrapOptionField("vmServerAddress", vmServerAddress)
    def getVmName: ZIO[Any, AwsError, VmName] =
      AwsError.unwrapOptionField("vmName", vmName)
    def getVmManagerName: ZIO[Any, AwsError, VmManagerName] =
      AwsError.unwrapOptionField("vmManagerName", vmManagerName)
    def getVmManagerType: ZIO[Any, AwsError, zio.aws.sms.model.VmManagerType] =
      AwsError.unwrapOptionField("vmManagerType", vmManagerType)
    def getVmPath: ZIO[Any, AwsError, VmPath] =
      AwsError.unwrapOptionField("vmPath", vmPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.VmServer
  ) extends zio.aws.sms.model.VmServer.ReadOnly {
    override val vmServerAddress
        : Optional[zio.aws.sms.model.VmServerAddress.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vmServerAddress())
        .map(value => zio.aws.sms.model.VmServerAddress.wrap(value))
    override val vmName: Optional[VmName] = zio.aws.core.internal
      .optionalFromNullable(impl.vmName())
      .map(value => zio.aws.sms.model.primitives.VmName(value))
    override val vmManagerName: Optional[VmManagerName] = zio.aws.core.internal
      .optionalFromNullable(impl.vmManagerName())
      .map(value => zio.aws.sms.model.primitives.VmManagerName(value))
    override val vmManagerType: Optional[zio.aws.sms.model.VmManagerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vmManagerType())
        .map(value => zio.aws.sms.model.VmManagerType.wrap(value))
    override val vmPath: Optional[VmPath] = zio.aws.core.internal
      .optionalFromNullable(impl.vmPath())
      .map(value => zio.aws.sms.model.primitives.VmPath(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.VmServer
  ): zio.aws.sms.model.VmServer.ReadOnly = new Wrapper(impl)
}
