package zio.aws.sms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AppValidationOutput(
    ssmOutput: Optional[zio.aws.sms.model.SSMOutput] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.AppValidationOutput = {
    import AppValidationOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.AppValidationOutput
      .builder()
      .optionallyWith(ssmOutput.map(value => value.buildAwsValue()))(
        _.ssmOutput
      )
      .build()
  }
  def asReadOnly: zio.aws.sms.model.AppValidationOutput.ReadOnly =
    zio.aws.sms.model.AppValidationOutput.wrap(buildAwsValue())
}
object AppValidationOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.AppValidationOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.AppValidationOutput = zio.aws.sms.model
      .AppValidationOutput(ssmOutput.map(value => value.asEditable))
    def ssmOutput: Optional[zio.aws.sms.model.SSMOutput.ReadOnly]
    def getSsmOutput: ZIO[Any, AwsError, zio.aws.sms.model.SSMOutput.ReadOnly] =
      AwsError.unwrapOptionField("ssmOutput", ssmOutput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.AppValidationOutput
  ) extends zio.aws.sms.model.AppValidationOutput.ReadOnly {
    override val ssmOutput: Optional[zio.aws.sms.model.SSMOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ssmOutput())
        .map(value => zio.aws.sms.model.SSMOutput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.AppValidationOutput
  ): zio.aws.sms.model.AppValidationOutput.ReadOnly = new Wrapper(impl)
}
