package zio.aws.sms.model
import scala.jdk.CollectionConverters._
sealed trait AppValidationStrategy {
  def unwrap: software.amazon.awssdk.services.sms.model.AppValidationStrategy
}
object AppValidationStrategy {
  def wrap(
      value: software.amazon.awssdk.services.sms.model.AppValidationStrategy
  ): zio.aws.sms.model.AppValidationStrategy = value match {
    case software.amazon.awssdk.services.sms.model.AppValidationStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sms.model.AppValidationStrategy.SSM =>
      val r = SSM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sms.model.AppValidationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppValidationStrategy =
      software.amazon.awssdk.services.sms.model.AppValidationStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object SSM extends zio.aws.sms.model.AppValidationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppValidationStrategy =
      software.amazon.awssdk.services.sms.model.AppValidationStrategy.SSM
  }
}
