package zio.aws.sms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GenerateChangeSetResponse(
    s3Location: Optional[zio.aws.sms.model.S3Location] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.GenerateChangeSetResponse = {
    import GenerateChangeSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.GenerateChangeSetResponse
      .builder()
      .optionallyWith(s3Location.map(value => value.buildAwsValue()))(
        _.s3Location
      )
      .build()
  }
  def asReadOnly: zio.aws.sms.model.GenerateChangeSetResponse.ReadOnly =
    zio.aws.sms.model.GenerateChangeSetResponse.wrap(buildAwsValue())
}
object GenerateChangeSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.GenerateChangeSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.GenerateChangeSetResponse =
      zio.aws.sms.model
        .GenerateChangeSetResponse(s3Location.map(value => value.asEditable))
    def s3Location: Optional[zio.aws.sms.model.S3Location.ReadOnly]
    def getS3Location
        : ZIO[Any, AwsError, zio.aws.sms.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("s3Location", s3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.GenerateChangeSetResponse
  ) extends zio.aws.sms.model.GenerateChangeSetResponse.ReadOnly {
    override val s3Location: Optional[zio.aws.sms.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Location())
        .map(value => zio.aws.sms.model.S3Location.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.GenerateChangeSetResponse
  ): zio.aws.sms.model.GenerateChangeSetResponse.ReadOnly = new Wrapper(impl)
}
