package zio.aws.sms.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sms.model.primitives.{MaxResults, NextToken}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetServersRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    vmServerAddressList: Optional[Iterable[zio.aws.sms.model.VmServerAddress]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.GetServersRequest = {
    import GetServersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.GetServersRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        vmServerAddressList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vmServerAddressList)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.GetServersRequest.ReadOnly =
    zio.aws.sms.model.GetServersRequest.wrap(buildAwsValue())
}
object GetServersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.GetServersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.GetServersRequest =
      zio.aws.sms.model.GetServersRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        vmServerAddressList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def vmServerAddressList
        : Optional[List[zio.aws.sms.model.VmServerAddress.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getVmServerAddressList
        : ZIO[Any, AwsError, List[zio.aws.sms.model.VmServerAddress.ReadOnly]] =
      AwsError.unwrapOptionField("vmServerAddressList", vmServerAddressList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.GetServersRequest
  ) extends zio.aws.sms.model.GetServersRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sms.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sms.model.primitives.MaxResults(value))
    override val vmServerAddressList
        : Optional[List[zio.aws.sms.model.VmServerAddress.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vmServerAddressList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sms.model.VmServerAddress.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.GetServersRequest
  ): zio.aws.sms.model.GetServersRequest.ReadOnly = new Wrapper(impl)
}
