package zio.aws.sms.model
import zio.aws.sms.model.primitives.AppId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LaunchAppRequest(appId: Optional[AppId] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.LaunchAppRequest = {
    import LaunchAppRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.LaunchAppRequest
      .builder()
      .optionallyWith(
        appId.map(value => AppId.unwrap(value): java.lang.String)
      )(_.appId)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.LaunchAppRequest.ReadOnly =
    zio.aws.sms.model.LaunchAppRequest.wrap(buildAwsValue())
}
object LaunchAppRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.LaunchAppRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.LaunchAppRequest =
      zio.aws.sms.model.LaunchAppRequest(appId.map(value => value))
    def appId: Optional[AppId]
    def getAppId: ZIO[Any, AwsError, AppId] =
      AwsError.unwrapOptionField("appId", appId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.LaunchAppRequest
  ) extends zio.aws.sms.model.LaunchAppRequest.ReadOnly {
    override val appId: Optional[AppId] = zio.aws.core.internal
      .optionalFromNullable(impl.appId())
      .map(value => zio.aws.sms.model.primitives.AppId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.LaunchAppRequest
  ): zio.aws.sms.model.LaunchAppRequest.ReadOnly = new Wrapper(impl)
}
