package zio.aws.sms.model
import zio.aws.sms.model.primitives.ServerGroupId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServerGroupReplicationConfiguration(
    serverGroupId: Optional[ServerGroupId] = Optional.Absent,
    serverReplicationConfigurations: Optional[
      Iterable[zio.aws.sms.model.ServerReplicationConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.ServerGroupReplicationConfiguration = {
    import ServerGroupReplicationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.ServerGroupReplicationConfiguration
      .builder()
      .optionallyWith(
        serverGroupId.map(value =>
          ServerGroupId.unwrap(value): java.lang.String
        )
      )(_.serverGroupId)
      .optionallyWith(
        serverReplicationConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serverReplicationConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.sms.model.ServerGroupReplicationConfiguration.ReadOnly =
    zio.aws.sms.model.ServerGroupReplicationConfiguration.wrap(buildAwsValue())
}
object ServerGroupReplicationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.ServerGroupReplicationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.ServerGroupReplicationConfiguration =
      zio.aws.sms.model.ServerGroupReplicationConfiguration(
        serverGroupId.map(value => value),
        serverReplicationConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serverGroupId: Optional[ServerGroupId]
    def serverReplicationConfigurations: Optional[
      List[zio.aws.sms.model.ServerReplicationConfiguration.ReadOnly]
    ]
    def getServerGroupId: ZIO[Any, AwsError, ServerGroupId] =
      AwsError.unwrapOptionField("serverGroupId", serverGroupId)
    def getServerReplicationConfigurations: ZIO[Any, AwsError, List[
      zio.aws.sms.model.ServerReplicationConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "serverReplicationConfigurations",
      serverReplicationConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.ServerGroupReplicationConfiguration
  ) extends zio.aws.sms.model.ServerGroupReplicationConfiguration.ReadOnly {
    override val serverGroupId: Optional[ServerGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.serverGroupId())
      .map(value => zio.aws.sms.model.primitives.ServerGroupId(value))
    override val serverReplicationConfigurations: Optional[
      List[zio.aws.sms.model.ServerReplicationConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverReplicationConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sms.model.ServerReplicationConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.ServerGroupReplicationConfiguration
  ): zio.aws.sms.model.ServerGroupReplicationConfiguration.ReadOnly =
    new Wrapper(impl)
}
