package zio.aws.sms.model
import zio.aws.sms.model.primitives.{
  Subnet,
  AssociatePublicIpAddress,
  RoleName,
  SecurityGroup,
  InstanceType,
  EC2KeyName,
  VPC,
  LogicalId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServerLaunchConfiguration(
    server: Optional[zio.aws.sms.model.Server] = Optional.Absent,
    logicalId: Optional[LogicalId] = Optional.Absent,
    vpc: Optional[VPC] = Optional.Absent,
    subnet: Optional[Subnet] = Optional.Absent,
    securityGroup: Optional[SecurityGroup] = Optional.Absent,
    ec2KeyName: Optional[EC2KeyName] = Optional.Absent,
    userData: Optional[zio.aws.sms.model.UserData] = Optional.Absent,
    instanceType: Optional[InstanceType] = Optional.Absent,
    associatePublicIpAddress: Optional[AssociatePublicIpAddress] =
      Optional.Absent,
    iamInstanceProfileName: Optional[RoleName] = Optional.Absent,
    configureScript: Optional[zio.aws.sms.model.S3Location] = Optional.Absent,
    configureScriptType: Optional[zio.aws.sms.model.ScriptType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.ServerLaunchConfiguration = {
    import ServerLaunchConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.ServerLaunchConfiguration
      .builder()
      .optionallyWith(server.map(value => value.buildAwsValue()))(_.server)
      .optionallyWith(
        logicalId.map(value => LogicalId.unwrap(value): java.lang.String)
      )(_.logicalId)
      .optionallyWith(vpc.map(value => VPC.unwrap(value): java.lang.String))(
        _.vpc
      )
      .optionallyWith(
        subnet.map(value => Subnet.unwrap(value): java.lang.String)
      )(_.subnet)
      .optionallyWith(
        securityGroup.map(value =>
          SecurityGroup.unwrap(value): java.lang.String
        )
      )(_.securityGroup)
      .optionallyWith(
        ec2KeyName.map(value => EC2KeyName.unwrap(value): java.lang.String)
      )(_.ec2KeyName)
      .optionallyWith(userData.map(value => value.buildAwsValue()))(_.userData)
      .optionallyWith(
        instanceType.map(value => InstanceType.unwrap(value): java.lang.String)
      )(_.instanceType)
      .optionallyWith(
        associatePublicIpAddress.map(value =>
          AssociatePublicIpAddress.unwrap(value): java.lang.Boolean
        )
      )(_.associatePublicIpAddress)
      .optionallyWith(
        iamInstanceProfileName.map(value =>
          RoleName.unwrap(value): java.lang.String
        )
      )(_.iamInstanceProfileName)
      .optionallyWith(configureScript.map(value => value.buildAwsValue()))(
        _.configureScript
      )
      .optionallyWith(configureScriptType.map(value => value.unwrap))(
        _.configureScriptType
      )
      .build()
  }
  def asReadOnly: zio.aws.sms.model.ServerLaunchConfiguration.ReadOnly =
    zio.aws.sms.model.ServerLaunchConfiguration.wrap(buildAwsValue())
}
object ServerLaunchConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.ServerLaunchConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.ServerLaunchConfiguration =
      zio.aws.sms.model.ServerLaunchConfiguration(
        server.map(value => value.asEditable),
        logicalId.map(value => value),
        vpc.map(value => value),
        subnet.map(value => value),
        securityGroup.map(value => value),
        ec2KeyName.map(value => value),
        userData.map(value => value.asEditable),
        instanceType.map(value => value),
        associatePublicIpAddress.map(value => value),
        iamInstanceProfileName.map(value => value),
        configureScript.map(value => value.asEditable),
        configureScriptType.map(value => value)
      )
    def server: Optional[zio.aws.sms.model.Server.ReadOnly]
    def logicalId: Optional[LogicalId]
    def vpc: Optional[VPC]
    def subnet: Optional[Subnet]
    def securityGroup: Optional[SecurityGroup]
    def ec2KeyName: Optional[EC2KeyName]
    def userData: Optional[zio.aws.sms.model.UserData.ReadOnly]
    def instanceType: Optional[InstanceType]
    def associatePublicIpAddress: Optional[AssociatePublicIpAddress]
    def iamInstanceProfileName: Optional[RoleName]
    def configureScript: Optional[zio.aws.sms.model.S3Location.ReadOnly]
    def configureScriptType: Optional[zio.aws.sms.model.ScriptType]
    def getServer: ZIO[Any, AwsError, zio.aws.sms.model.Server.ReadOnly] =
      AwsError.unwrapOptionField("server", server)
    def getLogicalId: ZIO[Any, AwsError, LogicalId] =
      AwsError.unwrapOptionField("logicalId", logicalId)
    def getVpc: ZIO[Any, AwsError, VPC] = AwsError.unwrapOptionField("vpc", vpc)
    def getSubnet: ZIO[Any, AwsError, Subnet] =
      AwsError.unwrapOptionField("subnet", subnet)
    def getSecurityGroup: ZIO[Any, AwsError, SecurityGroup] =
      AwsError.unwrapOptionField("securityGroup", securityGroup)
    def getEc2KeyName: ZIO[Any, AwsError, EC2KeyName] =
      AwsError.unwrapOptionField("ec2KeyName", ec2KeyName)
    def getUserData: ZIO[Any, AwsError, zio.aws.sms.model.UserData.ReadOnly] =
      AwsError.unwrapOptionField("userData", userData)
    def getInstanceType: ZIO[Any, AwsError, InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getAssociatePublicIpAddress
        : ZIO[Any, AwsError, AssociatePublicIpAddress] = AwsError
      .unwrapOptionField("associatePublicIpAddress", associatePublicIpAddress)
    def getIamInstanceProfileName: ZIO[Any, AwsError, RoleName] = AwsError
      .unwrapOptionField("iamInstanceProfileName", iamInstanceProfileName)
    def getConfigureScript
        : ZIO[Any, AwsError, zio.aws.sms.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("configureScript", configureScript)
    def getConfigureScriptType
        : ZIO[Any, AwsError, zio.aws.sms.model.ScriptType] =
      AwsError.unwrapOptionField("configureScriptType", configureScriptType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.ServerLaunchConfiguration
  ) extends zio.aws.sms.model.ServerLaunchConfiguration.ReadOnly {
    override val server: Optional[zio.aws.sms.model.Server.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.server())
        .map(value => zio.aws.sms.model.Server.wrap(value))
    override val logicalId: Optional[LogicalId] = zio.aws.core.internal
      .optionalFromNullable(impl.logicalId())
      .map(value => zio.aws.sms.model.primitives.LogicalId(value))
    override val vpc: Optional[VPC] = zio.aws.core.internal
      .optionalFromNullable(impl.vpc())
      .map(value => zio.aws.sms.model.primitives.VPC(value))
    override val subnet: Optional[Subnet] = zio.aws.core.internal
      .optionalFromNullable(impl.subnet())
      .map(value => zio.aws.sms.model.primitives.Subnet(value))
    override val securityGroup: Optional[SecurityGroup] = zio.aws.core.internal
      .optionalFromNullable(impl.securityGroup())
      .map(value => zio.aws.sms.model.primitives.SecurityGroup(value))
    override val ec2KeyName: Optional[EC2KeyName] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2KeyName())
      .map(value => zio.aws.sms.model.primitives.EC2KeyName(value))
    override val userData: Optional[zio.aws.sms.model.UserData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userData())
        .map(value => zio.aws.sms.model.UserData.wrap(value))
    override val instanceType: Optional[InstanceType] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => zio.aws.sms.model.primitives.InstanceType(value))
    override val associatePublicIpAddress: Optional[AssociatePublicIpAddress] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatePublicIpAddress())
        .map(value =>
          zio.aws.sms.model.primitives.AssociatePublicIpAddress(value)
        )
    override val iamInstanceProfileName: Optional[RoleName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamInstanceProfileName())
        .map(value => zio.aws.sms.model.primitives.RoleName(value))
    override val configureScript
        : Optional[zio.aws.sms.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configureScript())
        .map(value => zio.aws.sms.model.S3Location.wrap(value))
    override val configureScriptType: Optional[zio.aws.sms.model.ScriptType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configureScriptType())
        .map(value => zio.aws.sms.model.ScriptType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.ServerLaunchConfiguration
  ): zio.aws.sms.model.ServerLaunchConfiguration.ReadOnly = new Wrapper(impl)
}
