package zio.aws.sms.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sms.model.primitives.{
  Frequency,
  RunOnce,
  Timestamp,
  Encrypted,
  KmsKeyId,
  NumberOfRecentAmisToKeep
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ServerReplicationParameters(
    seedTime: Optional[Timestamp] = Optional.Absent,
    frequency: Optional[Frequency] = Optional.Absent,
    runOnce: Optional[RunOnce] = Optional.Absent,
    licenseType: Optional[zio.aws.sms.model.LicenseType] = Optional.Absent,
    numberOfRecentAmisToKeep: Optional[NumberOfRecentAmisToKeep] =
      Optional.Absent,
    encrypted: Optional[Encrypted] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.ServerReplicationParameters = {
    import ServerReplicationParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.ServerReplicationParameters
      .builder()
      .optionallyWith(seedTime.map(value => Timestamp.unwrap(value): Instant))(
        _.seedTime
      )
      .optionallyWith(frequency.map(value => Frequency.unwrap(value): Integer))(
        _.frequency
      )
      .optionallyWith(
        runOnce.map(value => RunOnce.unwrap(value): java.lang.Boolean)
      )(_.runOnce)
      .optionallyWith(licenseType.map(value => value.unwrap))(_.licenseType)
      .optionallyWith(
        numberOfRecentAmisToKeep.map(value =>
          NumberOfRecentAmisToKeep.unwrap(value): Integer
        )
      )(_.numberOfRecentAmisToKeep)
      .optionallyWith(
        encrypted.map(value => Encrypted.unwrap(value): java.lang.Boolean)
      )(_.encrypted)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.ServerReplicationParameters.ReadOnly =
    zio.aws.sms.model.ServerReplicationParameters.wrap(buildAwsValue())
}
object ServerReplicationParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.ServerReplicationParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.ServerReplicationParameters =
      zio.aws.sms.model.ServerReplicationParameters(
        seedTime.map(value => value),
        frequency.map(value => value),
        runOnce.map(value => value),
        licenseType.map(value => value),
        numberOfRecentAmisToKeep.map(value => value),
        encrypted.map(value => value),
        kmsKeyId.map(value => value)
      )
    def seedTime: Optional[Timestamp]
    def frequency: Optional[Frequency]
    def runOnce: Optional[RunOnce]
    def licenseType: Optional[zio.aws.sms.model.LicenseType]
    def numberOfRecentAmisToKeep: Optional[NumberOfRecentAmisToKeep]
    def encrypted: Optional[Encrypted]
    def kmsKeyId: Optional[KmsKeyId]
    def getSeedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("seedTime", seedTime)
    def getFrequency: ZIO[Any, AwsError, Frequency] =
      AwsError.unwrapOptionField("frequency", frequency)
    def getRunOnce: ZIO[Any, AwsError, RunOnce] =
      AwsError.unwrapOptionField("runOnce", runOnce)
    def getLicenseType: ZIO[Any, AwsError, zio.aws.sms.model.LicenseType] =
      AwsError.unwrapOptionField("licenseType", licenseType)
    def getNumberOfRecentAmisToKeep
        : ZIO[Any, AwsError, NumberOfRecentAmisToKeep] = AwsError
      .unwrapOptionField("numberOfRecentAmisToKeep", numberOfRecentAmisToKeep)
    def getEncrypted: ZIO[Any, AwsError, Encrypted] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.ServerReplicationParameters
  ) extends zio.aws.sms.model.ServerReplicationParameters.ReadOnly {
    override val seedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.seedTime())
      .map(value => zio.aws.sms.model.primitives.Timestamp(value))
    override val frequency: Optional[Frequency] = zio.aws.core.internal
      .optionalFromNullable(impl.frequency())
      .map(value => zio.aws.sms.model.primitives.Frequency(value))
    override val runOnce: Optional[RunOnce] = zio.aws.core.internal
      .optionalFromNullable(impl.runOnce())
      .map(value => zio.aws.sms.model.primitives.RunOnce(value))
    override val licenseType: Optional[zio.aws.sms.model.LicenseType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licenseType())
        .map(value => zio.aws.sms.model.LicenseType.wrap(value))
    override val numberOfRecentAmisToKeep: Optional[NumberOfRecentAmisToKeep] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfRecentAmisToKeep())
        .map(value =>
          zio.aws.sms.model.primitives.NumberOfRecentAmisToKeep(value)
        )
    override val encrypted: Optional[Encrypted] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => zio.aws.sms.model.primitives.Encrypted(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sms.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.ServerReplicationParameters
  ): zio.aws.sms.model.ServerReplicationParameters.ReadOnly = new Wrapper(impl)
}
