package zio.aws.sms.model
import scala.jdk.CollectionConverters._
sealed trait ServerValidationStrategy {
  def unwrap: software.amazon.awssdk.services.sms.model.ServerValidationStrategy
}
object ServerValidationStrategy {
  def wrap(
      value: software.amazon.awssdk.services.sms.model.ServerValidationStrategy
  ): zio.aws.sms.model.ServerValidationStrategy = value match {
    case software.amazon.awssdk.services.sms.model.ServerValidationStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sms.model.ServerValidationStrategy.USERDATA =>
      val r = USERDATA
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sms.model.ServerValidationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ServerValidationStrategy =
      software.amazon.awssdk.services.sms.model.ServerValidationStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object USERDATA extends zio.aws.sms.model.ServerValidationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ServerValidationStrategy =
      software.amazon.awssdk.services.sms.model.ServerValidationStrategy.USERDATA
  }
}
