package zio.aws.sms.model
import scala.jdk.CollectionConverters._
sealed trait VmManagerType {
  def unwrap: software.amazon.awssdk.services.sms.model.VmManagerType
}
object VmManagerType {
  def wrap(
      value: software.amazon.awssdk.services.sms.model.VmManagerType
  ): zio.aws.sms.model.VmManagerType = value match {
    case software.amazon.awssdk.services.sms.model.VmManagerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sms.model.VmManagerType.VSPHERE =>
      val r = VSPHERE
      r
    case software.amazon.awssdk.services.sms.model.VmManagerType.SCVMM =>
      val r = SCVMM
      r
    case software.amazon.awssdk.services.sms.model.VmManagerType.HYPERV_MANAGER =>
      val r = `HYPERV-MANAGER`
      r
  }
  case object unknownToSdkVersion extends zio.aws.sms.model.VmManagerType {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.VmManagerType =
      software.amazon.awssdk.services.sms.model.VmManagerType.UNKNOWN_TO_SDK_VERSION
  }
  case object VSPHERE extends zio.aws.sms.model.VmManagerType {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.VmManagerType =
      software.amazon.awssdk.services.sms.model.VmManagerType.VSPHERE
  }
  case object SCVMM extends zio.aws.sms.model.VmManagerType {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.VmManagerType =
      software.amazon.awssdk.services.sms.model.VmManagerType.SCVMM
  }
  case object `HYPERV-MANAGER` extends zio.aws.sms.model.VmManagerType {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.VmManagerType =
      software.amazon.awssdk.services.sms.model.VmManagerType.HYPERV_MANAGER
  }
}
