package zio.aws.sms
import zio.aws.sms.model.DeleteAppResponse.ReadOnly
import software.amazon.awssdk.services.sms.{
  SmsAsyncClientBuilder,
  SmsAsyncClient
}
import zio.aws.core.config.AwsConfig
import zio.aws.sms.model.{
  CreateAppRequest,
  GetReplicationJobsRequest,
  NotifyAppValidationOutputRequest,
  GenerateChangeSetRequest,
  UpdateAppRequest,
  StartAppReplicationRequest,
  DeleteAppReplicationConfigurationRequest,
  GetAppValidationOutputRequest,
  GenerateTemplateRequest,
  DeleteAppValidationConfigurationRequest,
  CreateReplicationJobRequest,
  DisassociateConnectorRequest,
  GetAppValidationConfigurationRequest,
  GetAppLaunchConfigurationRequest,
  DeleteAppLaunchConfigurationRequest,
  GetAppReplicationConfigurationRequest,
  DeleteServerCatalogRequest,
  GetServersRequest,
  LaunchAppRequest,
  ImportAppCatalogRequest,
  PutAppLaunchConfigurationRequest,
  GetAppRequest,
  ImportServerCatalogRequest,
  UpdateReplicationJobRequest,
  GetConnectorsRequest,
  DeleteReplicationJobRequest,
  GetReplicationRunsRequest,
  ListAppsRequest,
  StartOnDemandReplicationRunRequest,
  StartOnDemandAppReplicationRequest,
  TerminateAppRequest,
  DeleteAppRequest,
  PutAppValidationConfigurationRequest,
  PutAppReplicationConfigurationRequest,
  StopAppReplicationRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import software.amazon.awssdk.services.sms.model.{
  DeleteReplicationJobResponse,
  UpdateReplicationJobResponse,
  UpdateAppResponse,
  ImportAppCatalogResponse,
  GetConnectorsResponse,
  GetAppLaunchConfigurationResponse,
  ListAppsResponse,
  CreateReplicationJobResponse,
  NotifyAppValidationOutputResponse,
  GetAppValidationConfigurationResponse,
  LaunchAppResponse,
  DisassociateConnectorResponse,
  GetServersResponse,
  GetAppReplicationConfigurationResponse,
  GetAppValidationOutputResponse,
  Connector,
  GenerateTemplateResponse,
  PutAppValidationConfigurationResponse,
  GetAppResponse,
  GenerateChangeSetResponse,
  TerminateAppResponse,
  ReplicationJob,
  ImportServerCatalogResponse,
  StartOnDemandAppReplicationResponse,
  PutAppReplicationConfigurationResponse,
  StartAppReplicationResponse,
  GetReplicationJobsResponse,
  DeleteAppLaunchConfigurationResponse,
  DeleteAppResponse,
  DeleteAppReplicationConfigurationResponse,
  GetReplicationRunsResponse,
  StartOnDemandReplicationRunResponse,
  Server,
  StopAppReplicationResponse,
  DeleteAppValidationConfigurationResponse,
  DeleteServerCatalogResponse,
  CreateAppResponse,
  PutAppLaunchConfigurationResponse,
  ReplicationRun
}
import software.amazon.awssdk.services.sms.paginators.{
  GetReplicationJobsPublisher,
  GetServersPublisher,
  GetConnectorsPublisher,
  GetReplicationRunsPublisher
}
import scala.jdk.CollectionConverters._
trait Sms extends AspectSupport[Sms] {
  val api: SmsAsyncClient
  def getReplicationRuns(
      request: GetReplicationRunsRequest
  ): ZStream[Any, AwsError, zio.aws.sms.model.ReplicationRun.ReadOnly]
  def getReplicationRunsPaginated(
      request: GetReplicationRunsRequest
  ): IO[AwsError, zio.aws.sms.model.GetReplicationRunsResponse.ReadOnly]
  def putAppValidationConfiguration(
      request: PutAppValidationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.sms.model.PutAppValidationConfigurationResponse.ReadOnly
  ]
  def putAppLaunchConfiguration(
      request: PutAppLaunchConfigurationRequest
  ): IO[AwsError, zio.aws.sms.model.PutAppLaunchConfigurationResponse.ReadOnly]
  def importAppCatalog(
      request: ImportAppCatalogRequest
  ): IO[AwsError, zio.aws.sms.model.ImportAppCatalogResponse.ReadOnly]
  def generateChangeSet(
      request: GenerateChangeSetRequest
  ): IO[AwsError, zio.aws.sms.model.GenerateChangeSetResponse.ReadOnly]
  def getApp(
      request: GetAppRequest
  ): IO[AwsError, zio.aws.sms.model.GetAppResponse.ReadOnly]
  def startOnDemandReplicationRun(
      request: StartOnDemandReplicationRunRequest
  ): IO[
    AwsError,
    zio.aws.sms.model.StartOnDemandReplicationRunResponse.ReadOnly
  ]
  def startAppReplication(
      request: StartAppReplicationRequest
  ): IO[AwsError, zio.aws.sms.model.StartAppReplicationResponse.ReadOnly]
  def listApps(
      request: ListAppsRequest
  ): IO[AwsError, zio.aws.sms.model.ListAppsResponse.ReadOnly]
  def getAppValidationOutput(
      request: GetAppValidationOutputRequest
  ): IO[AwsError, zio.aws.sms.model.GetAppValidationOutputResponse.ReadOnly]
  def getConnectors(
      request: GetConnectorsRequest
  ): ZStream[Any, AwsError, zio.aws.sms.model.Connector.ReadOnly]
  def getConnectorsPaginated(
      request: GetConnectorsRequest
  ): IO[AwsError, zio.aws.sms.model.GetConnectorsResponse.ReadOnly]
  def stopAppReplication(
      request: StopAppReplicationRequest
  ): IO[AwsError, zio.aws.sms.model.StopAppReplicationResponse.ReadOnly]
  def getAppLaunchConfiguration(
      request: GetAppLaunchConfigurationRequest
  ): IO[AwsError, zio.aws.sms.model.GetAppLaunchConfigurationResponse.ReadOnly]
  def updateApp(
      request: UpdateAppRequest
  ): IO[AwsError, zio.aws.sms.model.UpdateAppResponse.ReadOnly]
  def putAppReplicationConfiguration(
      request: PutAppReplicationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.sms.model.PutAppReplicationConfigurationResponse.ReadOnly
  ]
  def deleteReplicationJob(
      request: DeleteReplicationJobRequest
  ): IO[AwsError, zio.aws.sms.model.DeleteReplicationJobResponse.ReadOnly]
  def createApp(
      request: CreateAppRequest
  ): IO[AwsError, zio.aws.sms.model.CreateAppResponse.ReadOnly]
  def launchApp(
      request: LaunchAppRequest
  ): IO[AwsError, zio.aws.sms.model.LaunchAppResponse.ReadOnly]
  def deleteApp(request: DeleteAppRequest): IO[AwsError, ReadOnly]
  def getAppValidationConfiguration(
      request: GetAppValidationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.sms.model.GetAppValidationConfigurationResponse.ReadOnly
  ]
  def notifyAppValidationOutput(
      request: NotifyAppValidationOutputRequest
  ): IO[AwsError, zio.aws.sms.model.NotifyAppValidationOutputResponse.ReadOnly]
  def updateReplicationJob(
      request: UpdateReplicationJobRequest
  ): IO[AwsError, zio.aws.sms.model.UpdateReplicationJobResponse.ReadOnly]
  def deleteAppValidationConfiguration(
      request: DeleteAppValidationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.sms.model.DeleteAppValidationConfigurationResponse.ReadOnly
  ]
  def importServerCatalog(
      request: ImportServerCatalogRequest
  ): IO[AwsError, zio.aws.sms.model.ImportServerCatalogResponse.ReadOnly]
  def deleteServerCatalog(
      request: DeleteServerCatalogRequest
  ): IO[AwsError, zio.aws.sms.model.DeleteServerCatalogResponse.ReadOnly]
  def generateTemplate(
      request: GenerateTemplateRequest
  ): IO[AwsError, zio.aws.sms.model.GenerateTemplateResponse.ReadOnly]
  def createReplicationJob(
      request: CreateReplicationJobRequest
  ): IO[AwsError, zio.aws.sms.model.CreateReplicationJobResponse.ReadOnly]
  def terminateApp(
      request: TerminateAppRequest
  ): IO[AwsError, zio.aws.sms.model.TerminateAppResponse.ReadOnly]
  def deleteAppReplicationConfiguration(
      request: DeleteAppReplicationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.sms.model.DeleteAppReplicationConfigurationResponse.ReadOnly
  ]
  def deleteAppLaunchConfiguration(
      request: DeleteAppLaunchConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.sms.model.DeleteAppLaunchConfigurationResponse.ReadOnly
  ]
  def startOnDemandAppReplication(
      request: StartOnDemandAppReplicationRequest
  ): IO[
    AwsError,
    zio.aws.sms.model.StartOnDemandAppReplicationResponse.ReadOnly
  ]
  def getAppReplicationConfiguration(
      request: GetAppReplicationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.sms.model.GetAppReplicationConfigurationResponse.ReadOnly
  ]
  def disassociateConnector(
      request: DisassociateConnectorRequest
  ): IO[AwsError, zio.aws.sms.model.DisassociateConnectorResponse.ReadOnly]
  def getServers(
      request: GetServersRequest
  ): ZStream[Any, AwsError, zio.aws.sms.model.Server.ReadOnly]
  def getServersPaginated(
      request: GetServersRequest
  ): IO[AwsError, zio.aws.sms.model.GetServersResponse.ReadOnly]
  def getReplicationJobs(
      request: GetReplicationJobsRequest
  ): ZStream[Any, AwsError, zio.aws.sms.model.ReplicationJob.ReadOnly]
  def getReplicationJobsPaginated(
      request: GetReplicationJobsRequest
  ): IO[AwsError, zio.aws.sms.model.GetReplicationJobsResponse.ReadOnly]
}
object Sms {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Sms] = customized(identity)
  def customized(
      customization: SmsAsyncClientBuilder => SmsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Sms] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: SmsAsyncClientBuilder => SmsAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Sms] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = SmsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[SmsAsyncClient, SmsAsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[SmsAsyncClient, SmsAsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  ) yield new SmsImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class SmsImpl[R](
      override val api: SmsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Sms
      with AwsServiceBase[R] {
    override val serviceName: String = "Sms"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SmsImpl[R1] = new SmsImpl(api, newAspect, r)
    def getReplicationRuns(
        request: GetReplicationRunsRequest
    ): ZStream[Any, AwsError, zio.aws.sms.model.ReplicationRun.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.sms.model.GetReplicationRunsRequest,
        ReplicationRun,
        GetReplicationRunsPublisher
      ](
        "getReplicationRuns",
        api.getReplicationRunsPaginator,
        _.replicationRunList()
      )(request.buildAwsValue())
        .map(item => zio.aws.sms.model.ReplicationRun.wrap(item))
        .provideEnvironment(r)
    def getReplicationRunsPaginated(
        request: GetReplicationRunsRequest
    ): IO[AwsError, zio.aws.sms.model.GetReplicationRunsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.GetReplicationRunsRequest,
        GetReplicationRunsResponse
      ]("getReplicationRuns", api.getReplicationRuns)(request.buildAwsValue())
        .map(zio.aws.sms.model.GetReplicationRunsResponse.wrap)
        .provideEnvironment(r)
    def putAppValidationConfiguration(
        request: PutAppValidationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.sms.model.PutAppValidationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sms.model.PutAppValidationConfigurationRequest,
      PutAppValidationConfigurationResponse
    ]("putAppValidationConfiguration", api.putAppValidationConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.sms.model.PutAppValidationConfigurationResponse.wrap)
      .provideEnvironment(r)
    def putAppLaunchConfiguration(
        request: PutAppLaunchConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.sms.model.PutAppLaunchConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sms.model.PutAppLaunchConfigurationRequest,
      PutAppLaunchConfigurationResponse
    ]("putAppLaunchConfiguration", api.putAppLaunchConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.sms.model.PutAppLaunchConfigurationResponse.wrap)
      .provideEnvironment(r)
    def importAppCatalog(
        request: ImportAppCatalogRequest
    ): IO[AwsError, zio.aws.sms.model.ImportAppCatalogResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.ImportAppCatalogRequest,
        ImportAppCatalogResponse
      ]("importAppCatalog", api.importAppCatalog)(request.buildAwsValue())
        .map(zio.aws.sms.model.ImportAppCatalogResponse.wrap)
        .provideEnvironment(r)
    def generateChangeSet(
        request: GenerateChangeSetRequest
    ): IO[AwsError, zio.aws.sms.model.GenerateChangeSetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.GenerateChangeSetRequest,
        GenerateChangeSetResponse
      ]("generateChangeSet", api.generateChangeSet)(request.buildAwsValue())
        .map(zio.aws.sms.model.GenerateChangeSetResponse.wrap)
        .provideEnvironment(r)
    def getApp(
        request: GetAppRequest
    ): IO[AwsError, zio.aws.sms.model.GetAppResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.GetAppRequest,
        GetAppResponse
      ]("getApp", api.getApp)(request.buildAwsValue())
        .map(zio.aws.sms.model.GetAppResponse.wrap)
        .provideEnvironment(r)
    def startOnDemandReplicationRun(
        request: StartOnDemandReplicationRunRequest
    ): IO[
      AwsError,
      zio.aws.sms.model.StartOnDemandReplicationRunResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sms.model.StartOnDemandReplicationRunRequest,
      StartOnDemandReplicationRunResponse
    ]("startOnDemandReplicationRun", api.startOnDemandReplicationRun)(
      request.buildAwsValue()
    ).map(zio.aws.sms.model.StartOnDemandReplicationRunResponse.wrap)
      .provideEnvironment(r)
    def startAppReplication(
        request: StartAppReplicationRequest
    ): IO[AwsError, zio.aws.sms.model.StartAppReplicationResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.StartAppReplicationRequest,
        StartAppReplicationResponse
      ]("startAppReplication", api.startAppReplication)(request.buildAwsValue())
        .map(zio.aws.sms.model.StartAppReplicationResponse.wrap)
        .provideEnvironment(r)
    def listApps(
        request: ListAppsRequest
    ): IO[AwsError, zio.aws.sms.model.ListAppsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.ListAppsRequest,
        ListAppsResponse
      ]("listApps", api.listApps)(request.buildAwsValue())
        .map(zio.aws.sms.model.ListAppsResponse.wrap)
        .provideEnvironment(r)
    def getAppValidationOutput(
        request: GetAppValidationOutputRequest
    ): IO[AwsError, zio.aws.sms.model.GetAppValidationOutputResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.GetAppValidationOutputRequest,
        GetAppValidationOutputResponse
      ]("getAppValidationOutput", api.getAppValidationOutput)(
        request.buildAwsValue()
      ).map(zio.aws.sms.model.GetAppValidationOutputResponse.wrap)
        .provideEnvironment(r)
    def getConnectors(
        request: GetConnectorsRequest
    ): ZStream[Any, AwsError, zio.aws.sms.model.Connector.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.sms.model.GetConnectorsRequest,
        Connector,
        GetConnectorsPublisher
      ]("getConnectors", api.getConnectorsPaginator, _.connectorList())(
        request.buildAwsValue()
      ).map(item => zio.aws.sms.model.Connector.wrap(item))
        .provideEnvironment(r)
    def getConnectorsPaginated(
        request: GetConnectorsRequest
    ): IO[AwsError, zio.aws.sms.model.GetConnectorsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.GetConnectorsRequest,
        GetConnectorsResponse
      ]("getConnectors", api.getConnectors)(request.buildAwsValue())
        .map(zio.aws.sms.model.GetConnectorsResponse.wrap)
        .provideEnvironment(r)
    def stopAppReplication(
        request: StopAppReplicationRequest
    ): IO[AwsError, zio.aws.sms.model.StopAppReplicationResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.StopAppReplicationRequest,
        StopAppReplicationResponse
      ]("stopAppReplication", api.stopAppReplication)(request.buildAwsValue())
        .map(zio.aws.sms.model.StopAppReplicationResponse.wrap)
        .provideEnvironment(r)
    def getAppLaunchConfiguration(
        request: GetAppLaunchConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.sms.model.GetAppLaunchConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sms.model.GetAppLaunchConfigurationRequest,
      GetAppLaunchConfigurationResponse
    ]("getAppLaunchConfiguration", api.getAppLaunchConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.sms.model.GetAppLaunchConfigurationResponse.wrap)
      .provideEnvironment(r)
    def updateApp(
        request: UpdateAppRequest
    ): IO[AwsError, zio.aws.sms.model.UpdateAppResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.UpdateAppRequest,
        UpdateAppResponse
      ]("updateApp", api.updateApp)(request.buildAwsValue())
        .map(zio.aws.sms.model.UpdateAppResponse.wrap)
        .provideEnvironment(r)
    def putAppReplicationConfiguration(
        request: PutAppReplicationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.sms.model.PutAppReplicationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sms.model.PutAppReplicationConfigurationRequest,
      PutAppReplicationConfigurationResponse
    ]("putAppReplicationConfiguration", api.putAppReplicationConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.sms.model.PutAppReplicationConfigurationResponse.wrap)
      .provideEnvironment(r)
    def deleteReplicationJob(
        request: DeleteReplicationJobRequest
    ): IO[AwsError, zio.aws.sms.model.DeleteReplicationJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.DeleteReplicationJobRequest,
        DeleteReplicationJobResponse
      ]("deleteReplicationJob", api.deleteReplicationJob)(
        request.buildAwsValue()
      ).map(zio.aws.sms.model.DeleteReplicationJobResponse.wrap)
        .provideEnvironment(r)
    def createApp(
        request: CreateAppRequest
    ): IO[AwsError, zio.aws.sms.model.CreateAppResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.CreateAppRequest,
        CreateAppResponse
      ]("createApp", api.createApp)(request.buildAwsValue())
        .map(zio.aws.sms.model.CreateAppResponse.wrap)
        .provideEnvironment(r)
    def launchApp(
        request: LaunchAppRequest
    ): IO[AwsError, zio.aws.sms.model.LaunchAppResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.LaunchAppRequest,
        LaunchAppResponse
      ]("launchApp", api.launchApp)(request.buildAwsValue())
        .map(zio.aws.sms.model.LaunchAppResponse.wrap)
        .provideEnvironment(r)
    def deleteApp(request: DeleteAppRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.DeleteAppRequest,
        DeleteAppResponse
      ]("deleteApp", api.deleteApp)(request.buildAwsValue())
        .map(zio.aws.sms.model.DeleteAppResponse.wrap)
        .provideEnvironment(r)
    def getAppValidationConfiguration(
        request: GetAppValidationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.sms.model.GetAppValidationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sms.model.GetAppValidationConfigurationRequest,
      GetAppValidationConfigurationResponse
    ]("getAppValidationConfiguration", api.getAppValidationConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.sms.model.GetAppValidationConfigurationResponse.wrap)
      .provideEnvironment(r)
    def notifyAppValidationOutput(
        request: NotifyAppValidationOutputRequest
    ): IO[
      AwsError,
      zio.aws.sms.model.NotifyAppValidationOutputResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sms.model.NotifyAppValidationOutputRequest,
      NotifyAppValidationOutputResponse
    ]("notifyAppValidationOutput", api.notifyAppValidationOutput)(
      request.buildAwsValue()
    ).map(zio.aws.sms.model.NotifyAppValidationOutputResponse.wrap)
      .provideEnvironment(r)
    def updateReplicationJob(
        request: UpdateReplicationJobRequest
    ): IO[AwsError, zio.aws.sms.model.UpdateReplicationJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.UpdateReplicationJobRequest,
        UpdateReplicationJobResponse
      ]("updateReplicationJob", api.updateReplicationJob)(
        request.buildAwsValue()
      ).map(zio.aws.sms.model.UpdateReplicationJobResponse.wrap)
        .provideEnvironment(r)
    def deleteAppValidationConfiguration(
        request: DeleteAppValidationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.sms.model.DeleteAppValidationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sms.model.DeleteAppValidationConfigurationRequest,
      DeleteAppValidationConfigurationResponse
    ]("deleteAppValidationConfiguration", api.deleteAppValidationConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.sms.model.DeleteAppValidationConfigurationResponse.wrap)
      .provideEnvironment(r)
    def importServerCatalog(
        request: ImportServerCatalogRequest
    ): IO[AwsError, zio.aws.sms.model.ImportServerCatalogResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.ImportServerCatalogRequest,
        ImportServerCatalogResponse
      ]("importServerCatalog", api.importServerCatalog)(request.buildAwsValue())
        .map(zio.aws.sms.model.ImportServerCatalogResponse.wrap)
        .provideEnvironment(r)
    def deleteServerCatalog(
        request: DeleteServerCatalogRequest
    ): IO[AwsError, zio.aws.sms.model.DeleteServerCatalogResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.DeleteServerCatalogRequest,
        DeleteServerCatalogResponse
      ]("deleteServerCatalog", api.deleteServerCatalog)(request.buildAwsValue())
        .map(zio.aws.sms.model.DeleteServerCatalogResponse.wrap)
        .provideEnvironment(r)
    def generateTemplate(
        request: GenerateTemplateRequest
    ): IO[AwsError, zio.aws.sms.model.GenerateTemplateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.GenerateTemplateRequest,
        GenerateTemplateResponse
      ]("generateTemplate", api.generateTemplate)(request.buildAwsValue())
        .map(zio.aws.sms.model.GenerateTemplateResponse.wrap)
        .provideEnvironment(r)
    def createReplicationJob(
        request: CreateReplicationJobRequest
    ): IO[AwsError, zio.aws.sms.model.CreateReplicationJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.CreateReplicationJobRequest,
        CreateReplicationJobResponse
      ]("createReplicationJob", api.createReplicationJob)(
        request.buildAwsValue()
      ).map(zio.aws.sms.model.CreateReplicationJobResponse.wrap)
        .provideEnvironment(r)
    def terminateApp(
        request: TerminateAppRequest
    ): IO[AwsError, zio.aws.sms.model.TerminateAppResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.TerminateAppRequest,
        TerminateAppResponse
      ]("terminateApp", api.terminateApp)(request.buildAwsValue())
        .map(zio.aws.sms.model.TerminateAppResponse.wrap)
        .provideEnvironment(r)
    def deleteAppReplicationConfiguration(
        request: DeleteAppReplicationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.sms.model.DeleteAppReplicationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sms.model.DeleteAppReplicationConfigurationRequest,
      DeleteAppReplicationConfigurationResponse
    ](
      "deleteAppReplicationConfiguration",
      api.deleteAppReplicationConfiguration
    )(request.buildAwsValue())
      .map(zio.aws.sms.model.DeleteAppReplicationConfigurationResponse.wrap)
      .provideEnvironment(r)
    def deleteAppLaunchConfiguration(
        request: DeleteAppLaunchConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.sms.model.DeleteAppLaunchConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sms.model.DeleteAppLaunchConfigurationRequest,
      DeleteAppLaunchConfigurationResponse
    ]("deleteAppLaunchConfiguration", api.deleteAppLaunchConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.sms.model.DeleteAppLaunchConfigurationResponse.wrap)
      .provideEnvironment(r)
    def startOnDemandAppReplication(
        request: StartOnDemandAppReplicationRequest
    ): IO[
      AwsError,
      zio.aws.sms.model.StartOnDemandAppReplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sms.model.StartOnDemandAppReplicationRequest,
      StartOnDemandAppReplicationResponse
    ]("startOnDemandAppReplication", api.startOnDemandAppReplication)(
      request.buildAwsValue()
    ).map(zio.aws.sms.model.StartOnDemandAppReplicationResponse.wrap)
      .provideEnvironment(r)
    def getAppReplicationConfiguration(
        request: GetAppReplicationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.sms.model.GetAppReplicationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sms.model.GetAppReplicationConfigurationRequest,
      GetAppReplicationConfigurationResponse
    ]("getAppReplicationConfiguration", api.getAppReplicationConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.sms.model.GetAppReplicationConfigurationResponse.wrap)
      .provideEnvironment(r)
    def disassociateConnector(
        request: DisassociateConnectorRequest
    ): IO[AwsError, zio.aws.sms.model.DisassociateConnectorResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.DisassociateConnectorRequest,
        DisassociateConnectorResponse
      ]("disassociateConnector", api.disassociateConnector)(
        request.buildAwsValue()
      ).map(zio.aws.sms.model.DisassociateConnectorResponse.wrap)
        .provideEnvironment(r)
    def getServers(
        request: GetServersRequest
    ): ZStream[Any, AwsError, zio.aws.sms.model.Server.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.sms.model.GetServersRequest,
        Server,
        GetServersPublisher
      ]("getServers", api.getServersPaginator, _.serverList())(
        request.buildAwsValue()
      ).map(item => zio.aws.sms.model.Server.wrap(item)).provideEnvironment(r)
    def getServersPaginated(
        request: GetServersRequest
    ): IO[AwsError, zio.aws.sms.model.GetServersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.GetServersRequest,
        GetServersResponse
      ]("getServers", api.getServers)(request.buildAwsValue())
        .map(zio.aws.sms.model.GetServersResponse.wrap)
        .provideEnvironment(r)
    def getReplicationJobs(
        request: GetReplicationJobsRequest
    ): ZStream[Any, AwsError, zio.aws.sms.model.ReplicationJob.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.sms.model.GetReplicationJobsRequest,
        ReplicationJob,
        GetReplicationJobsPublisher
      ](
        "getReplicationJobs",
        api.getReplicationJobsPaginator,
        _.replicationJobList()
      )(request.buildAwsValue())
        .map(item => zio.aws.sms.model.ReplicationJob.wrap(item))
        .provideEnvironment(r)
    def getReplicationJobsPaginated(
        request: GetReplicationJobsRequest
    ): IO[AwsError, zio.aws.sms.model.GetReplicationJobsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sms.model.GetReplicationJobsRequest,
        GetReplicationJobsResponse
      ]("getReplicationJobs", api.getReplicationJobs)(request.buildAwsValue())
        .map(zio.aws.sms.model.GetReplicationJobsResponse.wrap)
        .provideEnvironment(r)
  }
  def getReplicationRuns(request: GetReplicationRunsRequest): ZStream[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.ReplicationRun.ReadOnly
  ] = ZStream.serviceWithStream(_.getReplicationRuns(request))
  def getReplicationRunsPaginated(request: GetReplicationRunsRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.GetReplicationRunsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getReplicationRunsPaginated(request))
  def putAppValidationConfiguration(
      request: PutAppValidationConfigurationRequest
  ): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.PutAppValidationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAppValidationConfiguration(request))
  def putAppLaunchConfiguration(request: PutAppLaunchConfigurationRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.PutAppLaunchConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAppLaunchConfiguration(request))
  def importAppCatalog(request: ImportAppCatalogRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.ImportAppCatalogResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importAppCatalog(request))
  def generateChangeSet(request: GenerateChangeSetRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.GenerateChangeSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.generateChangeSet(request))
  def getApp(
      request: GetAppRequest
  ): ZIO[zio.aws.sms.Sms, AwsError, zio.aws.sms.model.GetAppResponse.ReadOnly] =
    ZIO.serviceWithZIO(_.getApp(request))
  def startOnDemandReplicationRun(
      request: StartOnDemandReplicationRunRequest
  ): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.StartOnDemandReplicationRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startOnDemandReplicationRun(request))
  def startAppReplication(request: StartAppReplicationRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.StartAppReplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startAppReplication(request))
  def listApps(request: ListAppsRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.ListAppsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApps(request))
  def getAppValidationOutput(request: GetAppValidationOutputRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.GetAppValidationOutputResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAppValidationOutput(request))
  def getConnectors(
      request: GetConnectorsRequest
  ): ZStream[zio.aws.sms.Sms, AwsError, zio.aws.sms.model.Connector.ReadOnly] =
    ZStream.serviceWithStream(_.getConnectors(request))
  def getConnectorsPaginated(request: GetConnectorsRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.GetConnectorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getConnectorsPaginated(request))
  def stopAppReplication(request: StopAppReplicationRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.StopAppReplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopAppReplication(request))
  def getAppLaunchConfiguration(request: GetAppLaunchConfigurationRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.GetAppLaunchConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAppLaunchConfiguration(request))
  def updateApp(request: UpdateAppRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.UpdateAppResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApp(request))
  def putAppReplicationConfiguration(
      request: PutAppReplicationConfigurationRequest
  ): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.PutAppReplicationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAppReplicationConfiguration(request))
  def deleteReplicationJob(request: DeleteReplicationJobRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.DeleteReplicationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReplicationJob(request))
  def createApp(request: CreateAppRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.CreateAppResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApp(request))
  def launchApp(request: LaunchAppRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.LaunchAppResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.launchApp(request))
  def deleteApp(
      request: DeleteAppRequest
  ): ZIO[zio.aws.sms.Sms, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.deleteApp(request))
  def getAppValidationConfiguration(
      request: GetAppValidationConfigurationRequest
  ): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.GetAppValidationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAppValidationConfiguration(request))
  def notifyAppValidationOutput(request: NotifyAppValidationOutputRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.NotifyAppValidationOutputResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.notifyAppValidationOutput(request))
  def updateReplicationJob(request: UpdateReplicationJobRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.UpdateReplicationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateReplicationJob(request))
  def deleteAppValidationConfiguration(
      request: DeleteAppValidationConfigurationRequest
  ): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.DeleteAppValidationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAppValidationConfiguration(request))
  def importServerCatalog(request: ImportServerCatalogRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.ImportServerCatalogResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importServerCatalog(request))
  def deleteServerCatalog(request: DeleteServerCatalogRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.DeleteServerCatalogResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteServerCatalog(request))
  def generateTemplate(request: GenerateTemplateRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.GenerateTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.generateTemplate(request))
  def createReplicationJob(request: CreateReplicationJobRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.CreateReplicationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createReplicationJob(request))
  def terminateApp(request: TerminateAppRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.TerminateAppResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.terminateApp(request))
  def deleteAppReplicationConfiguration(
      request: DeleteAppReplicationConfigurationRequest
  ): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.DeleteAppReplicationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAppReplicationConfiguration(request))
  def deleteAppLaunchConfiguration(
      request: DeleteAppLaunchConfigurationRequest
  ): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.DeleteAppLaunchConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAppLaunchConfiguration(request))
  def startOnDemandAppReplication(
      request: StartOnDemandAppReplicationRequest
  ): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.StartOnDemandAppReplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startOnDemandAppReplication(request))
  def getAppReplicationConfiguration(
      request: GetAppReplicationConfigurationRequest
  ): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.GetAppReplicationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAppReplicationConfiguration(request))
  def disassociateConnector(request: DisassociateConnectorRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.DisassociateConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateConnector(request))
  def getServers(
      request: GetServersRequest
  ): ZStream[zio.aws.sms.Sms, AwsError, zio.aws.sms.model.Server.ReadOnly] =
    ZStream.serviceWithStream(_.getServers(request))
  def getServersPaginated(request: GetServersRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.GetServersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getServersPaginated(request))
  def getReplicationJobs(request: GetReplicationJobsRequest): ZStream[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.ReplicationJob.ReadOnly
  ] = ZStream.serviceWithStream(_.getReplicationJobs(request))
  def getReplicationJobsPaginated(request: GetReplicationJobsRequest): ZIO[
    zio.aws.sms.Sms,
    AwsError,
    zio.aws.sms.model.GetReplicationJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getReplicationJobsPaginated(request))
}
