package zio.aws.sms.model
import scala.jdk.CollectionConverters._
sealed trait AppReplicationStatus {
  def unwrap: software.amazon.awssdk.services.sms.model.AppReplicationStatus
}
object AppReplicationStatus {
  def wrap(
      value: software.amazon.awssdk.services.sms.model.AppReplicationStatus
  ): zio.aws.sms.model.AppReplicationStatus = value match {
    case software.amazon.awssdk.services.sms.model.AppReplicationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sms.model.AppReplicationStatus.READY_FOR_CONFIGURATION =>
      val r = READY_FOR_CONFIGURATION
      r
    case software.amazon.awssdk.services.sms.model.AppReplicationStatus.CONFIGURATION_IN_PROGRESS =>
      val r = CONFIGURATION_IN_PROGRESS
      r
    case software.amazon.awssdk.services.sms.model.AppReplicationStatus.CONFIGURATION_INVALID =>
      val r = CONFIGURATION_INVALID
      r
    case software.amazon.awssdk.services.sms.model.AppReplicationStatus.READY_FOR_REPLICATION =>
      val r = READY_FOR_REPLICATION
      r
    case software.amazon.awssdk.services.sms.model.AppReplicationStatus.VALIDATION_IN_PROGRESS =>
      val r = VALIDATION_IN_PROGRESS
      r
    case software.amazon.awssdk.services.sms.model.AppReplicationStatus.REPLICATION_PENDING =>
      val r = REPLICATION_PENDING
      r
    case software.amazon.awssdk.services.sms.model.AppReplicationStatus.REPLICATION_IN_PROGRESS =>
      val r = REPLICATION_IN_PROGRESS
      r
    case software.amazon.awssdk.services.sms.model.AppReplicationStatus.REPLICATED =>
      val r = REPLICATED
      r
    case software.amazon.awssdk.services.sms.model.AppReplicationStatus.PARTIALLY_REPLICATED =>
      val r = PARTIALLY_REPLICATED
      r
    case software.amazon.awssdk.services.sms.model.AppReplicationStatus.DELTA_REPLICATION_IN_PROGRESS =>
      val r = DELTA_REPLICATION_IN_PROGRESS
      r
    case software.amazon.awssdk.services.sms.model.AppReplicationStatus.DELTA_REPLICATED =>
      val r = DELTA_REPLICATED
      r
    case software.amazon.awssdk.services.sms.model.AppReplicationStatus.DELTA_REPLICATION_FAILED =>
      val r = DELTA_REPLICATION_FAILED
      r
    case software.amazon.awssdk.services.sms.model.AppReplicationStatus.REPLICATION_FAILED =>
      val r = REPLICATION_FAILED
      r
    case software.amazon.awssdk.services.sms.model.AppReplicationStatus.REPLICATION_STOPPING =>
      val r = REPLICATION_STOPPING
      r
    case software.amazon.awssdk.services.sms.model.AppReplicationStatus.REPLICATION_STOP_FAILED =>
      val r = REPLICATION_STOP_FAILED
      r
    case software.amazon.awssdk.services.sms.model.AppReplicationStatus.REPLICATION_STOPPED =>
      val r = REPLICATION_STOPPED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sms.model.AppReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppReplicationStatus =
      software.amazon.awssdk.services.sms.model.AppReplicationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object READY_FOR_CONFIGURATION
      extends zio.aws.sms.model.AppReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppReplicationStatus =
      software.amazon.awssdk.services.sms.model.AppReplicationStatus.READY_FOR_CONFIGURATION
  }
  case object CONFIGURATION_IN_PROGRESS
      extends zio.aws.sms.model.AppReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppReplicationStatus =
      software.amazon.awssdk.services.sms.model.AppReplicationStatus.CONFIGURATION_IN_PROGRESS
  }
  case object CONFIGURATION_INVALID
      extends zio.aws.sms.model.AppReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppReplicationStatus =
      software.amazon.awssdk.services.sms.model.AppReplicationStatus.CONFIGURATION_INVALID
  }
  case object READY_FOR_REPLICATION
      extends zio.aws.sms.model.AppReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppReplicationStatus =
      software.amazon.awssdk.services.sms.model.AppReplicationStatus.READY_FOR_REPLICATION
  }
  case object VALIDATION_IN_PROGRESS
      extends zio.aws.sms.model.AppReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppReplicationStatus =
      software.amazon.awssdk.services.sms.model.AppReplicationStatus.VALIDATION_IN_PROGRESS
  }
  case object REPLICATION_PENDING
      extends zio.aws.sms.model.AppReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppReplicationStatus =
      software.amazon.awssdk.services.sms.model.AppReplicationStatus.REPLICATION_PENDING
  }
  case object REPLICATION_IN_PROGRESS
      extends zio.aws.sms.model.AppReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppReplicationStatus =
      software.amazon.awssdk.services.sms.model.AppReplicationStatus.REPLICATION_IN_PROGRESS
  }
  case object REPLICATED extends zio.aws.sms.model.AppReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppReplicationStatus =
      software.amazon.awssdk.services.sms.model.AppReplicationStatus.REPLICATED
  }
  case object PARTIALLY_REPLICATED
      extends zio.aws.sms.model.AppReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppReplicationStatus =
      software.amazon.awssdk.services.sms.model.AppReplicationStatus.PARTIALLY_REPLICATED
  }
  case object DELTA_REPLICATION_IN_PROGRESS
      extends zio.aws.sms.model.AppReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppReplicationStatus =
      software.amazon.awssdk.services.sms.model.AppReplicationStatus.DELTA_REPLICATION_IN_PROGRESS
  }
  case object DELTA_REPLICATED extends zio.aws.sms.model.AppReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppReplicationStatus =
      software.amazon.awssdk.services.sms.model.AppReplicationStatus.DELTA_REPLICATED
  }
  case object DELTA_REPLICATION_FAILED
      extends zio.aws.sms.model.AppReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppReplicationStatus =
      software.amazon.awssdk.services.sms.model.AppReplicationStatus.DELTA_REPLICATION_FAILED
  }
  case object REPLICATION_FAILED
      extends zio.aws.sms.model.AppReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppReplicationStatus =
      software.amazon.awssdk.services.sms.model.AppReplicationStatus.REPLICATION_FAILED
  }
  case object REPLICATION_STOPPING
      extends zio.aws.sms.model.AppReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppReplicationStatus =
      software.amazon.awssdk.services.sms.model.AppReplicationStatus.REPLICATION_STOPPING
  }
  case object REPLICATION_STOP_FAILED
      extends zio.aws.sms.model.AppReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppReplicationStatus =
      software.amazon.awssdk.services.sms.model.AppReplicationStatus.REPLICATION_STOP_FAILED
  }
  case object REPLICATION_STOPPED
      extends zio.aws.sms.model.AppReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppReplicationStatus =
      software.amazon.awssdk.services.sms.model.AppReplicationStatus.REPLICATION_STOPPED
  }
}
