package zio.aws.sms.model
import zio.aws.sms.model.primitives.AppId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAppReplicationConfigurationRequest(
    appId: Optional[AppId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.GetAppReplicationConfigurationRequest = {
    import GetAppReplicationConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.GetAppReplicationConfigurationRequest
      .builder()
      .optionallyWith(
        appId.map(value => AppId.unwrap(value): java.lang.String)
      )(_.appId)
      .build()
  }
  def asReadOnly
      : zio.aws.sms.model.GetAppReplicationConfigurationRequest.ReadOnly =
    zio.aws.sms.model.GetAppReplicationConfigurationRequest
      .wrap(buildAwsValue())
}
object GetAppReplicationConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.GetAppReplicationConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.GetAppReplicationConfigurationRequest =
      zio.aws.sms.model
        .GetAppReplicationConfigurationRequest(appId.map(value => value))
    def appId: Optional[AppId]
    def getAppId: ZIO[Any, AwsError, AppId] =
      AwsError.unwrapOptionField("appId", appId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.GetAppReplicationConfigurationRequest
  ) extends zio.aws.sms.model.GetAppReplicationConfigurationRequest.ReadOnly {
    override val appId: Optional[AppId] = zio.aws.core.internal
      .optionalFromNullable(impl.appId())
      .map(value => zio.aws.sms.model.primitives.AppId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.GetAppReplicationConfigurationRequest
  ): zio.aws.sms.model.GetAppReplicationConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
