package zio.aws.sms.model
import zio.aws.sms.model.primitives.AppIdWithValidation
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetAppValidationOutputRequest(appId: AppIdWithValidation) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.GetAppValidationOutputRequest = {
    import GetAppValidationOutputRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.GetAppValidationOutputRequest
      .builder()
      .appId(AppIdWithValidation.unwrap(appId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.GetAppValidationOutputRequest.ReadOnly =
    zio.aws.sms.model.GetAppValidationOutputRequest.wrap(buildAwsValue())
}
object GetAppValidationOutputRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.GetAppValidationOutputRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.GetAppValidationOutputRequest =
      zio.aws.sms.model.GetAppValidationOutputRequest(appId)
    def appId: AppIdWithValidation
    def getAppId: ZIO[Any, Nothing, AppIdWithValidation] = ZIO.succeed(appId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.GetAppValidationOutputRequest
  ) extends zio.aws.sms.model.GetAppValidationOutputRequest.ReadOnly {
    override val appId: AppIdWithValidation =
      zio.aws.sms.model.primitives.AppIdWithValidation(impl.appId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.GetAppValidationOutputRequest
  ): zio.aws.sms.model.GetAppValidationOutputRequest.ReadOnly = new Wrapper(
    impl
  )
}
