package zio.aws.sms.model
import scala.jdk.CollectionConverters._
sealed trait ReplicationJobState {
  def unwrap: software.amazon.awssdk.services.sms.model.ReplicationJobState
}
object ReplicationJobState {
  def wrap(
      value: software.amazon.awssdk.services.sms.model.ReplicationJobState
  ): zio.aws.sms.model.ReplicationJobState = value match {
    case software.amazon.awssdk.services.sms.model.ReplicationJobState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sms.model.ReplicationJobState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.sms.model.ReplicationJobState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.sms.model.ReplicationJobState.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.sms.model.ReplicationJobState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.sms.model.ReplicationJobState.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.sms.model.ReplicationJobState.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.sms.model.ReplicationJobState.PAUSED_ON_FAILURE =>
      val r = PAUSED_ON_FAILURE
      r
    case software.amazon.awssdk.services.sms.model.ReplicationJobState.FAILING =>
      val r = FAILING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sms.model.ReplicationJobState {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ReplicationJobState =
      software.amazon.awssdk.services.sms.model.ReplicationJobState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.sms.model.ReplicationJobState {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ReplicationJobState =
      software.amazon.awssdk.services.sms.model.ReplicationJobState.PENDING
  }
  case object ACTIVE extends zio.aws.sms.model.ReplicationJobState {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ReplicationJobState =
      software.amazon.awssdk.services.sms.model.ReplicationJobState.ACTIVE
  }
  case object FAILED extends zio.aws.sms.model.ReplicationJobState {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ReplicationJobState =
      software.amazon.awssdk.services.sms.model.ReplicationJobState.FAILED
  }
  case object DELETING extends zio.aws.sms.model.ReplicationJobState {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ReplicationJobState =
      software.amazon.awssdk.services.sms.model.ReplicationJobState.DELETING
  }
  case object DELETED extends zio.aws.sms.model.ReplicationJobState {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ReplicationJobState =
      software.amazon.awssdk.services.sms.model.ReplicationJobState.DELETED
  }
  case object COMPLETED extends zio.aws.sms.model.ReplicationJobState {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ReplicationJobState =
      software.amazon.awssdk.services.sms.model.ReplicationJobState.COMPLETED
  }
  case object PAUSED_ON_FAILURE extends zio.aws.sms.model.ReplicationJobState {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ReplicationJobState =
      software.amazon.awssdk.services.sms.model.ReplicationJobState.PAUSED_ON_FAILURE
  }
  case object FAILING extends zio.aws.sms.model.ReplicationJobState {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ReplicationJobState =
      software.amazon.awssdk.services.sms.model.ReplicationJobState.FAILING
  }
}
