package zio.aws.sms.model
import scala.jdk.CollectionConverters._
sealed trait ReplicationRunState {
  def unwrap: software.amazon.awssdk.services.sms.model.ReplicationRunState
}
object ReplicationRunState {
  def wrap(
      value: software.amazon.awssdk.services.sms.model.ReplicationRunState
  ): zio.aws.sms.model.ReplicationRunState = value match {
    case software.amazon.awssdk.services.sms.model.ReplicationRunState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sms.model.ReplicationRunState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.sms.model.ReplicationRunState.MISSED =>
      val r = MISSED
      r
    case software.amazon.awssdk.services.sms.model.ReplicationRunState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.sms.model.ReplicationRunState.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.sms.model.ReplicationRunState.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.sms.model.ReplicationRunState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.sms.model.ReplicationRunState.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sms.model.ReplicationRunState {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ReplicationRunState =
      software.amazon.awssdk.services.sms.model.ReplicationRunState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.sms.model.ReplicationRunState {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ReplicationRunState =
      software.amazon.awssdk.services.sms.model.ReplicationRunState.PENDING
  }
  case object MISSED extends zio.aws.sms.model.ReplicationRunState {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ReplicationRunState =
      software.amazon.awssdk.services.sms.model.ReplicationRunState.MISSED
  }
  case object ACTIVE extends zio.aws.sms.model.ReplicationRunState {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ReplicationRunState =
      software.amazon.awssdk.services.sms.model.ReplicationRunState.ACTIVE
  }
  case object FAILED extends zio.aws.sms.model.ReplicationRunState {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ReplicationRunState =
      software.amazon.awssdk.services.sms.model.ReplicationRunState.FAILED
  }
  case object COMPLETED extends zio.aws.sms.model.ReplicationRunState {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ReplicationRunState =
      software.amazon.awssdk.services.sms.model.ReplicationRunState.COMPLETED
  }
  case object DELETING extends zio.aws.sms.model.ReplicationRunState {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ReplicationRunState =
      software.amazon.awssdk.services.sms.model.ReplicationRunState.DELETING
  }
  case object DELETED extends zio.aws.sms.model.ReplicationRunState {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ReplicationRunState =
      software.amazon.awssdk.services.sms.model.ReplicationRunState.DELETED
  }
}
