package zio.aws.sms.model
import zio.aws.sms.model.primitives.AppId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartAppReplicationRequest(
    appId: Optional[AppId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.StartAppReplicationRequest = {
    import StartAppReplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.StartAppReplicationRequest
      .builder()
      .optionallyWith(
        appId.map(value => AppId.unwrap(value): java.lang.String)
      )(_.appId)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.StartAppReplicationRequest.ReadOnly =
    zio.aws.sms.model.StartAppReplicationRequest.wrap(buildAwsValue())
}
object StartAppReplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.StartAppReplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.StartAppReplicationRequest =
      zio.aws.sms.model.StartAppReplicationRequest(appId.map(value => value))
    def appId: Optional[AppId]
    def getAppId: ZIO[Any, AwsError, AppId] =
      AwsError.unwrapOptionField("appId", appId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.StartAppReplicationRequest
  ) extends zio.aws.sms.model.StartAppReplicationRequest.ReadOnly {
    override val appId: Optional[AppId] = zio.aws.core.internal
      .optionalFromNullable(impl.appId())
      .map(value => zio.aws.sms.model.primitives.AppId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.StartAppReplicationRequest
  ): zio.aws.sms.model.StartAppReplicationRequest.ReadOnly = new Wrapper(impl)
}
