package zio.aws.sms.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sms.model.primitives.{
  Timestamp,
  ValidationStatusMessage,
  NonEmptyStringWithMaxLen255,
  ValidationId
}
import scala.jdk.CollectionConverters._
final case class ValidationOutput(
    validationId: Optional[ValidationId] = Optional.Absent,
    name: Optional[NonEmptyStringWithMaxLen255] = Optional.Absent,
    status: Optional[zio.aws.sms.model.ValidationStatus] = Optional.Absent,
    statusMessage: Optional[ValidationStatusMessage] = Optional.Absent,
    latestValidationTime: Optional[Timestamp] = Optional.Absent,
    appValidationOutput: Optional[zio.aws.sms.model.AppValidationOutput] =
      Optional.Absent,
    serverValidationOutput: Optional[zio.aws.sms.model.ServerValidationOutput] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.ValidationOutput = {
    import ValidationOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.ValidationOutput
      .builder()
      .optionallyWith(
        validationId.map(value => ValidationId.unwrap(value): java.lang.String)
      )(_.validationId)
      .optionallyWith(
        name.map(value =>
          NonEmptyStringWithMaxLen255.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          ValidationStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        latestValidationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestValidationTime)
      .optionallyWith(appValidationOutput.map(value => value.buildAwsValue()))(
        _.appValidationOutput
      )
      .optionallyWith(
        serverValidationOutput.map(value => value.buildAwsValue())
      )(_.serverValidationOutput)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.ValidationOutput.ReadOnly =
    zio.aws.sms.model.ValidationOutput.wrap(buildAwsValue())
}
object ValidationOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.ValidationOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.ValidationOutput =
      zio.aws.sms.model.ValidationOutput(
        validationId.map(value => value),
        name.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        latestValidationTime.map(value => value),
        appValidationOutput.map(value => value.asEditable),
        serverValidationOutput.map(value => value.asEditable)
      )
    def validationId: Optional[ValidationId]
    def name: Optional[NonEmptyStringWithMaxLen255]
    def status: Optional[zio.aws.sms.model.ValidationStatus]
    def statusMessage: Optional[ValidationStatusMessage]
    def latestValidationTime: Optional[Timestamp]
    def appValidationOutput
        : Optional[zio.aws.sms.model.AppValidationOutput.ReadOnly]
    def serverValidationOutput
        : Optional[zio.aws.sms.model.ServerValidationOutput.ReadOnly]
    def getValidationId: ZIO[Any, AwsError, ValidationId] =
      AwsError.unwrapOptionField("validationId", validationId)
    def getName: ZIO[Any, AwsError, NonEmptyStringWithMaxLen255] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, zio.aws.sms.model.ValidationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, ValidationStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getLatestValidationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("latestValidationTime", latestValidationTime)
    def getAppValidationOutput
        : ZIO[Any, AwsError, zio.aws.sms.model.AppValidationOutput.ReadOnly] =
      AwsError.unwrapOptionField("appValidationOutput", appValidationOutput)
    def getServerValidationOutput: ZIO[
      Any,
      AwsError,
      zio.aws.sms.model.ServerValidationOutput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverValidationOutput",
      serverValidationOutput
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.ValidationOutput
  ) extends zio.aws.sms.model.ValidationOutput.ReadOnly {
    override val validationId: Optional[ValidationId] = zio.aws.core.internal
      .optionalFromNullable(impl.validationId())
      .map(value => zio.aws.sms.model.primitives.ValidationId(value))
    override val name: Optional[NonEmptyStringWithMaxLen255] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.sms.model.primitives.NonEmptyStringWithMaxLen255(value)
        )
    override val status: Optional[zio.aws.sms.model.ValidationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sms.model.ValidationStatus.wrap(value))
    override val statusMessage: Optional[ValidationStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.sms.model.primitives.ValidationStatusMessage(value)
        )
    override val latestValidationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestValidationTime())
        .map(value => zio.aws.sms.model.primitives.Timestamp(value))
    override val appValidationOutput
        : Optional[zio.aws.sms.model.AppValidationOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appValidationOutput())
        .map(value => zio.aws.sms.model.AppValidationOutput.wrap(value))
    override val serverValidationOutput
        : Optional[zio.aws.sms.model.ServerValidationOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverValidationOutput())
        .map(value => zio.aws.sms.model.ServerValidationOutput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.ValidationOutput
  ): zio.aws.sms.model.ValidationOutput.ReadOnly = new Wrapper(impl)
}
