package zio.aws.sms.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sms.model.primitives.{
  AppStatusMessage,
  TotalServers,
  AppLaunchStatusMessage,
  ImportedAppId,
  Timestamp,
  RoleName,
  TotalServerGroups,
  AppName,
  AppId,
  AppReplicationStatusMessage,
  AppDescription
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AppSummary(
    appId: Optional[AppId] = Optional.Absent,
    importedAppId: Optional[ImportedAppId] = Optional.Absent,
    name: Optional[AppName] = Optional.Absent,
    description: Optional[AppDescription] = Optional.Absent,
    status: Optional[zio.aws.sms.model.AppStatus] = Optional.Absent,
    statusMessage: Optional[AppStatusMessage] = Optional.Absent,
    replicationConfigurationStatus: Optional[
      zio.aws.sms.model.AppReplicationConfigurationStatus
    ] = Optional.Absent,
    replicationStatus: Optional[zio.aws.sms.model.AppReplicationStatus] =
      Optional.Absent,
    replicationStatusMessage: Optional[AppReplicationStatusMessage] =
      Optional.Absent,
    latestReplicationTime: Optional[Timestamp] = Optional.Absent,
    launchConfigurationStatus: Optional[
      zio.aws.sms.model.AppLaunchConfigurationStatus
    ] = Optional.Absent,
    launchStatus: Optional[zio.aws.sms.model.AppLaunchStatus] = Optional.Absent,
    launchStatusMessage: Optional[AppLaunchStatusMessage] = Optional.Absent,
    launchDetails: Optional[zio.aws.sms.model.LaunchDetails] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModified: Optional[Timestamp] = Optional.Absent,
    roleName: Optional[RoleName] = Optional.Absent,
    totalServerGroups: Optional[TotalServerGroups] = Optional.Absent,
    totalServers: Optional[TotalServers] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.sms.model.AppSummary = {
    import AppSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.AppSummary
      .builder()
      .optionallyWith(
        appId.map(value => AppId.unwrap(value): java.lang.String)
      )(_.appId)
      .optionallyWith(
        importedAppId.map(value =>
          ImportedAppId.unwrap(value): java.lang.String
        )
      )(_.importedAppId)
      .optionallyWith(
        name.map(value => AppName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => AppDescription.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          AppStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        replicationConfigurationStatus.map(value => value.unwrap)
      )(_.replicationConfigurationStatus)
      .optionallyWith(replicationStatus.map(value => value.unwrap))(
        _.replicationStatus
      )
      .optionallyWith(
        replicationStatusMessage.map(value =>
          AppReplicationStatusMessage.unwrap(value): java.lang.String
        )
      )(_.replicationStatusMessage)
      .optionallyWith(
        latestReplicationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestReplicationTime)
      .optionallyWith(launchConfigurationStatus.map(value => value.unwrap))(
        _.launchConfigurationStatus
      )
      .optionallyWith(launchStatus.map(value => value.unwrap))(_.launchStatus)
      .optionallyWith(
        launchStatusMessage.map(value =>
          AppLaunchStatusMessage.unwrap(value): java.lang.String
        )
      )(_.launchStatusMessage)
      .optionallyWith(launchDetails.map(value => value.buildAwsValue()))(
        _.launchDetails
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModified.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(
        roleName.map(value => RoleName.unwrap(value): java.lang.String)
      )(_.roleName)
      .optionallyWith(
        totalServerGroups.map(value => TotalServerGroups.unwrap(value): Integer)
      )(_.totalServerGroups)
      .optionallyWith(
        totalServers.map(value => TotalServers.unwrap(value): Integer)
      )(_.totalServers)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.AppSummary.ReadOnly =
    zio.aws.sms.model.AppSummary.wrap(buildAwsValue())
}
object AppSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sms.model.AppSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.AppSummary = zio.aws.sms.model.AppSummary(
      appId.map(value => value),
      importedAppId.map(value => value),
      name.map(value => value),
      description.map(value => value),
      status.map(value => value),
      statusMessage.map(value => value),
      replicationConfigurationStatus.map(value => value),
      replicationStatus.map(value => value),
      replicationStatusMessage.map(value => value),
      latestReplicationTime.map(value => value),
      launchConfigurationStatus.map(value => value),
      launchStatus.map(value => value),
      launchStatusMessage.map(value => value),
      launchDetails.map(value => value.asEditable),
      creationTime.map(value => value),
      lastModified.map(value => value),
      roleName.map(value => value),
      totalServerGroups.map(value => value),
      totalServers.map(value => value)
    )
    def appId: Optional[AppId]
    def importedAppId: Optional[ImportedAppId]
    def name: Optional[AppName]
    def description: Optional[AppDescription]
    def status: Optional[zio.aws.sms.model.AppStatus]
    def statusMessage: Optional[AppStatusMessage]
    def replicationConfigurationStatus
        : Optional[zio.aws.sms.model.AppReplicationConfigurationStatus]
    def replicationStatus: Optional[zio.aws.sms.model.AppReplicationStatus]
    def replicationStatusMessage: Optional[AppReplicationStatusMessage]
    def latestReplicationTime: Optional[Timestamp]
    def launchConfigurationStatus
        : Optional[zio.aws.sms.model.AppLaunchConfigurationStatus]
    def launchStatus: Optional[zio.aws.sms.model.AppLaunchStatus]
    def launchStatusMessage: Optional[AppLaunchStatusMessage]
    def launchDetails: Optional[zio.aws.sms.model.LaunchDetails.ReadOnly]
    def creationTime: Optional[Timestamp]
    def lastModified: Optional[Timestamp]
    def roleName: Optional[RoleName]
    def totalServerGroups: Optional[TotalServerGroups]
    def totalServers: Optional[TotalServers]
    def getAppId: ZIO[Any, AwsError, AppId] =
      AwsError.unwrapOptionField("appId", appId)
    def getImportedAppId: ZIO[Any, AwsError, ImportedAppId] =
      AwsError.unwrapOptionField("importedAppId", importedAppId)
    def getName: ZIO[Any, AwsError, AppName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, AppDescription] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[Any, AwsError, zio.aws.sms.model.AppStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, AppStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getReplicationConfigurationStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sms.model.AppReplicationConfigurationStatus
    ] = AwsError.unwrapOptionField(
      "replicationConfigurationStatus",
      replicationConfigurationStatus
    )
    def getReplicationStatus
        : ZIO[Any, AwsError, zio.aws.sms.model.AppReplicationStatus] =
      AwsError.unwrapOptionField("replicationStatus", replicationStatus)
    def getReplicationStatusMessage
        : ZIO[Any, AwsError, AppReplicationStatusMessage] = AwsError
      .unwrapOptionField("replicationStatusMessage", replicationStatusMessage)
    def getLatestReplicationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("latestReplicationTime", latestReplicationTime)
    def getLaunchConfigurationStatus
        : ZIO[Any, AwsError, zio.aws.sms.model.AppLaunchConfigurationStatus] =
      AwsError.unwrapOptionField(
        "launchConfigurationStatus",
        launchConfigurationStatus
      )
    def getLaunchStatus: ZIO[Any, AwsError, zio.aws.sms.model.AppLaunchStatus] =
      AwsError.unwrapOptionField("launchStatus", launchStatus)
    def getLaunchStatusMessage: ZIO[Any, AwsError, AppLaunchStatusMessage] =
      AwsError.unwrapOptionField("launchStatusMessage", launchStatusMessage)
    def getLaunchDetails
        : ZIO[Any, AwsError, zio.aws.sms.model.LaunchDetails.ReadOnly] =
      AwsError.unwrapOptionField("launchDetails", launchDetails)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModified: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getRoleName: ZIO[Any, AwsError, RoleName] =
      AwsError.unwrapOptionField("roleName", roleName)
    def getTotalServerGroups: ZIO[Any, AwsError, TotalServerGroups] =
      AwsError.unwrapOptionField("totalServerGroups", totalServerGroups)
    def getTotalServers: ZIO[Any, AwsError, TotalServers] =
      AwsError.unwrapOptionField("totalServers", totalServers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.AppSummary
  ) extends zio.aws.sms.model.AppSummary.ReadOnly {
    override val appId: Optional[AppId] = zio.aws.core.internal
      .optionalFromNullable(impl.appId())
      .map(value => zio.aws.sms.model.primitives.AppId(value))
    override val importedAppId: Optional[ImportedAppId] = zio.aws.core.internal
      .optionalFromNullable(impl.importedAppId())
      .map(value => zio.aws.sms.model.primitives.ImportedAppId(value))
    override val name: Optional[AppName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.sms.model.primitives.AppName(value))
    override val description: Optional[AppDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.sms.model.primitives.AppDescription(value))
    override val status: Optional[zio.aws.sms.model.AppStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sms.model.AppStatus.wrap(value))
    override val statusMessage: Optional[AppStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value => zio.aws.sms.model.primitives.AppStatusMessage(value))
    override val replicationConfigurationStatus
        : Optional[zio.aws.sms.model.AppReplicationConfigurationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationConfigurationStatus())
        .map(value =>
          zio.aws.sms.model.AppReplicationConfigurationStatus.wrap(value)
        )
    override val replicationStatus
        : Optional[zio.aws.sms.model.AppReplicationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationStatus())
        .map(value => zio.aws.sms.model.AppReplicationStatus.wrap(value))
    override val replicationStatusMessage
        : Optional[AppReplicationStatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationStatusMessage())
      .map(value =>
        zio.aws.sms.model.primitives.AppReplicationStatusMessage(value)
      )
    override val latestReplicationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestReplicationTime())
        .map(value => zio.aws.sms.model.primitives.Timestamp(value))
    override val launchConfigurationStatus
        : Optional[zio.aws.sms.model.AppLaunchConfigurationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchConfigurationStatus())
        .map(value =>
          zio.aws.sms.model.AppLaunchConfigurationStatus.wrap(value)
        )
    override val launchStatus: Optional[zio.aws.sms.model.AppLaunchStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchStatus())
        .map(value => zio.aws.sms.model.AppLaunchStatus.wrap(value))
    override val launchStatusMessage: Optional[AppLaunchStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchStatusMessage())
        .map(value =>
          zio.aws.sms.model.primitives.AppLaunchStatusMessage(value)
        )
    override val launchDetails
        : Optional[zio.aws.sms.model.LaunchDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchDetails())
        .map(value => zio.aws.sms.model.LaunchDetails.wrap(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sms.model.primitives.Timestamp(value))
    override val lastModified: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value => zio.aws.sms.model.primitives.Timestamp(value))
    override val roleName: Optional[RoleName] = zio.aws.core.internal
      .optionalFromNullable(impl.roleName())
      .map(value => zio.aws.sms.model.primitives.RoleName(value))
    override val totalServerGroups: Optional[TotalServerGroups] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalServerGroups())
        .map(value => zio.aws.sms.model.primitives.TotalServerGroups(value))
    override val totalServers: Optional[TotalServers] = zio.aws.core.internal
      .optionalFromNullable(impl.totalServers())
      .map(value => zio.aws.sms.model.primitives.TotalServers(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.AppSummary
  ): zio.aws.sms.model.AppSummary.ReadOnly = new Wrapper(impl)
}
