package zio.aws.sms.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sms.model.primitives.{
  VmManagerName,
  MacAddress,
  Timestamp,
  ConnectorId,
  VmManagerId,
  IpAddress,
  ConnectorVersion
}
import scala.jdk.CollectionConverters._
final case class Connector(
    connectorId: Optional[ConnectorId] = Optional.Absent,
    version: Optional[ConnectorVersion] = Optional.Absent,
    status: Optional[zio.aws.sms.model.ConnectorStatus] = Optional.Absent,
    capabilityList: Optional[Iterable[zio.aws.sms.model.ConnectorCapability]] =
      Optional.Absent,
    vmManagerName: Optional[VmManagerName] = Optional.Absent,
    vmManagerType: Optional[zio.aws.sms.model.VmManagerType] = Optional.Absent,
    vmManagerId: Optional[VmManagerId] = Optional.Absent,
    ipAddress: Optional[IpAddress] = Optional.Absent,
    macAddress: Optional[MacAddress] = Optional.Absent,
    associatedOn: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.sms.model.Connector = {
    import Connector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.Connector
      .builder()
      .optionallyWith(
        connectorId.map(value => ConnectorId.unwrap(value): java.lang.String)
      )(_.connectorId)
      .optionallyWith(
        version.map(value => ConnectorVersion.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        capabilityList.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilityListWithStrings)
      .optionallyWith(
        vmManagerName.map(value =>
          VmManagerName.unwrap(value): java.lang.String
        )
      )(_.vmManagerName)
      .optionallyWith(vmManagerType.map(value => value.unwrap))(_.vmManagerType)
      .optionallyWith(
        vmManagerId.map(value => VmManagerId.unwrap(value): java.lang.String)
      )(_.vmManagerId)
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(
        macAddress.map(value => MacAddress.unwrap(value): java.lang.String)
      )(_.macAddress)
      .optionallyWith(
        associatedOn.map(value => Timestamp.unwrap(value): Instant)
      )(_.associatedOn)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.Connector.ReadOnly =
    zio.aws.sms.model.Connector.wrap(buildAwsValue())
}
object Connector {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sms.model.Connector] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.Connector = zio.aws.sms.model.Connector(
      connectorId.map(value => value),
      version.map(value => value),
      status.map(value => value),
      capabilityList.map(value => value),
      vmManagerName.map(value => value),
      vmManagerType.map(value => value),
      vmManagerId.map(value => value),
      ipAddress.map(value => value),
      macAddress.map(value => value),
      associatedOn.map(value => value)
    )
    def connectorId: Optional[ConnectorId]
    def version: Optional[ConnectorVersion]
    def status: Optional[zio.aws.sms.model.ConnectorStatus]
    def capabilityList: Optional[List[zio.aws.sms.model.ConnectorCapability]]
    def vmManagerName: Optional[VmManagerName]
    def vmManagerType: Optional[zio.aws.sms.model.VmManagerType]
    def vmManagerId: Optional[VmManagerId]
    def ipAddress: Optional[IpAddress]
    def macAddress: Optional[MacAddress]
    def associatedOn: Optional[Timestamp]
    def getConnectorId: ZIO[Any, AwsError, ConnectorId] =
      AwsError.unwrapOptionField("connectorId", connectorId)
    def getVersion: ZIO[Any, AwsError, ConnectorVersion] =
      AwsError.unwrapOptionField("version", version)
    def getStatus: ZIO[Any, AwsError, zio.aws.sms.model.ConnectorStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCapabilityList
        : ZIO[Any, AwsError, List[zio.aws.sms.model.ConnectorCapability]] =
      AwsError.unwrapOptionField("capabilityList", capabilityList)
    def getVmManagerName: ZIO[Any, AwsError, VmManagerName] =
      AwsError.unwrapOptionField("vmManagerName", vmManagerName)
    def getVmManagerType: ZIO[Any, AwsError, zio.aws.sms.model.VmManagerType] =
      AwsError.unwrapOptionField("vmManagerType", vmManagerType)
    def getVmManagerId: ZIO[Any, AwsError, VmManagerId] =
      AwsError.unwrapOptionField("vmManagerId", vmManagerId)
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getMacAddress: ZIO[Any, AwsError, MacAddress] =
      AwsError.unwrapOptionField("macAddress", macAddress)
    def getAssociatedOn: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("associatedOn", associatedOn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.Connector
  ) extends zio.aws.sms.model.Connector.ReadOnly {
    override val connectorId: Optional[ConnectorId] = zio.aws.core.internal
      .optionalFromNullable(impl.connectorId())
      .map(value => zio.aws.sms.model.primitives.ConnectorId(value))
    override val version: Optional[ConnectorVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.sms.model.primitives.ConnectorVersion(value))
    override val status: Optional[zio.aws.sms.model.ConnectorStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sms.model.ConnectorStatus.wrap(value))
    override val capabilityList
        : Optional[List[zio.aws.sms.model.ConnectorCapability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilityList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sms.model.ConnectorCapability.wrap(item)
          }.toList
        )
    override val vmManagerName: Optional[VmManagerName] = zio.aws.core.internal
      .optionalFromNullable(impl.vmManagerName())
      .map(value => zio.aws.sms.model.primitives.VmManagerName(value))
    override val vmManagerType: Optional[zio.aws.sms.model.VmManagerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vmManagerType())
        .map(value => zio.aws.sms.model.VmManagerType.wrap(value))
    override val vmManagerId: Optional[VmManagerId] = zio.aws.core.internal
      .optionalFromNullable(impl.vmManagerId())
      .map(value => zio.aws.sms.model.primitives.VmManagerId(value))
    override val ipAddress: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => zio.aws.sms.model.primitives.IpAddress(value))
    override val macAddress: Optional[MacAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.macAddress())
      .map(value => zio.aws.sms.model.primitives.MacAddress(value))
    override val associatedOn: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.associatedOn())
      .map(value => zio.aws.sms.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.Connector
  ): zio.aws.sms.model.Connector.ReadOnly = new Wrapper(impl)
}
