package zio.aws.sms.model
import zio.aws.sms.model.primitives.ConnectorId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateConnectorRequest(connectorId: ConnectorId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.DisassociateConnectorRequest = {
    import DisassociateConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.DisassociateConnectorRequest
      .builder()
      .connectorId(ConnectorId.unwrap(connectorId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.DisassociateConnectorRequest.ReadOnly =
    zio.aws.sms.model.DisassociateConnectorRequest.wrap(buildAwsValue())
}
object DisassociateConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.DisassociateConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.DisassociateConnectorRequest =
      zio.aws.sms.model.DisassociateConnectorRequest(connectorId)
    def connectorId: ConnectorId
    def getConnectorId: ZIO[Any, Nothing, ConnectorId] =
      ZIO.succeed(connectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.DisassociateConnectorRequest
  ) extends zio.aws.sms.model.DisassociateConnectorRequest.ReadOnly {
    override val connectorId: ConnectorId =
      zio.aws.sms.model.primitives.ConnectorId(impl.connectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.DisassociateConnectorRequest
  ): zio.aws.sms.model.DisassociateConnectorRequest.ReadOnly = new Wrapper(impl)
}
