package zio.aws.sms.model
import zio.aws.sms.model.primitives.AppIdWithValidation
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetAppValidationConfigurationRequest(
    appId: AppIdWithValidation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.GetAppValidationConfigurationRequest = {
    import GetAppValidationConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.GetAppValidationConfigurationRequest
      .builder()
      .appId(AppIdWithValidation.unwrap(appId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sms.model.GetAppValidationConfigurationRequest.ReadOnly =
    zio.aws.sms.model.GetAppValidationConfigurationRequest.wrap(buildAwsValue())
}
object GetAppValidationConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.GetAppValidationConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.GetAppValidationConfigurationRequest =
      zio.aws.sms.model.GetAppValidationConfigurationRequest(appId)
    def appId: AppIdWithValidation
    def getAppId: ZIO[Any, Nothing, AppIdWithValidation] = ZIO.succeed(appId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.GetAppValidationConfigurationRequest
  ) extends zio.aws.sms.model.GetAppValidationConfigurationRequest.ReadOnly {
    override val appId: AppIdWithValidation =
      zio.aws.sms.model.primitives.AppIdWithValidation(impl.appId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.GetAppValidationConfigurationRequest
  ): zio.aws.sms.model.GetAppValidationConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
