package zio.aws.sms.model
import scala.jdk.CollectionConverters._
sealed trait OutputFormat {
  def unwrap: software.amazon.awssdk.services.sms.model.OutputFormat
}
object OutputFormat {
  def wrap(
      value: software.amazon.awssdk.services.sms.model.OutputFormat
  ): zio.aws.sms.model.OutputFormat = value match {
    case software.amazon.awssdk.services.sms.model.OutputFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sms.model.OutputFormat.JSON =>
      val r = JSON
      r
    case software.amazon.awssdk.services.sms.model.OutputFormat.YAML =>
      val r = YAML
      r
  }
  case object unknownToSdkVersion extends zio.aws.sms.model.OutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.OutputFormat =
      software.amazon.awssdk.services.sms.model.OutputFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object JSON extends zio.aws.sms.model.OutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.OutputFormat =
      software.amazon.awssdk.services.sms.model.OutputFormat.JSON
  }
  case object YAML extends zio.aws.sms.model.OutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.OutputFormat =
      software.amazon.awssdk.services.sms.model.OutputFormat.YAML
  }
}
