package zio.aws.sms.model
import zio.aws.sms.model.primitives.{NonEmptyStringWithMaxLen255, ValidationId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServerValidationConfiguration(
    server: Optional[zio.aws.sms.model.Server] = Optional.Absent,
    validationId: Optional[ValidationId] = Optional.Absent,
    name: Optional[NonEmptyStringWithMaxLen255] = Optional.Absent,
    serverValidationStrategy: Optional[
      zio.aws.sms.model.ServerValidationStrategy
    ] = Optional.Absent,
    userDataValidationParameters: Optional[
      zio.aws.sms.model.UserDataValidationParameters
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.ServerValidationConfiguration = {
    import ServerValidationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.ServerValidationConfiguration
      .builder()
      .optionallyWith(server.map(value => value.buildAwsValue()))(_.server)
      .optionallyWith(
        validationId.map(value => ValidationId.unwrap(value): java.lang.String)
      )(_.validationId)
      .optionallyWith(
        name.map(value =>
          NonEmptyStringWithMaxLen255.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(serverValidationStrategy.map(value => value.unwrap))(
        _.serverValidationStrategy
      )
      .optionallyWith(
        userDataValidationParameters.map(value => value.buildAwsValue())
      )(_.userDataValidationParameters)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.ServerValidationConfiguration.ReadOnly =
    zio.aws.sms.model.ServerValidationConfiguration.wrap(buildAwsValue())
}
object ServerValidationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.ServerValidationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.ServerValidationConfiguration =
      zio.aws.sms.model.ServerValidationConfiguration(
        server.map(value => value.asEditable),
        validationId.map(value => value),
        name.map(value => value),
        serverValidationStrategy.map(value => value),
        userDataValidationParameters.map(value => value.asEditable)
      )
    def server: Optional[zio.aws.sms.model.Server.ReadOnly]
    def validationId: Optional[ValidationId]
    def name: Optional[NonEmptyStringWithMaxLen255]
    def serverValidationStrategy
        : Optional[zio.aws.sms.model.ServerValidationStrategy]
    def userDataValidationParameters
        : Optional[zio.aws.sms.model.UserDataValidationParameters.ReadOnly]
    def getServer: ZIO[Any, AwsError, zio.aws.sms.model.Server.ReadOnly] =
      AwsError.unwrapOptionField("server", server)
    def getValidationId: ZIO[Any, AwsError, ValidationId] =
      AwsError.unwrapOptionField("validationId", validationId)
    def getName: ZIO[Any, AwsError, NonEmptyStringWithMaxLen255] =
      AwsError.unwrapOptionField("name", name)
    def getServerValidationStrategy
        : ZIO[Any, AwsError, zio.aws.sms.model.ServerValidationStrategy] =
      AwsError.unwrapOptionField(
        "serverValidationStrategy",
        serverValidationStrategy
      )
    def getUserDataValidationParameters: ZIO[
      Any,
      AwsError,
      zio.aws.sms.model.UserDataValidationParameters.ReadOnly
    ] = AwsError.unwrapOptionField(
      "userDataValidationParameters",
      userDataValidationParameters
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.ServerValidationConfiguration
  ) extends zio.aws.sms.model.ServerValidationConfiguration.ReadOnly {
    override val server: Optional[zio.aws.sms.model.Server.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.server())
        .map(value => zio.aws.sms.model.Server.wrap(value))
    override val validationId: Optional[ValidationId] = zio.aws.core.internal
      .optionalFromNullable(impl.validationId())
      .map(value => zio.aws.sms.model.primitives.ValidationId(value))
    override val name: Optional[NonEmptyStringWithMaxLen255] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.sms.model.primitives.NonEmptyStringWithMaxLen255(value)
        )
    override val serverValidationStrategy
        : Optional[zio.aws.sms.model.ServerValidationStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverValidationStrategy())
        .map(value => zio.aws.sms.model.ServerValidationStrategy.wrap(value))
    override val userDataValidationParameters
        : Optional[zio.aws.sms.model.UserDataValidationParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userDataValidationParameters())
        .map(value =>
          zio.aws.sms.model.UserDataValidationParameters.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.ServerValidationConfiguration
  ): zio.aws.sms.model.ServerValidationConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
