package zio.aws.sms.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sms.model.primitives.{
  Frequency,
  ReplicationJobId,
  Timestamp,
  RoleName,
  Encrypted,
  KmsKeyId,
  Description,
  NumberOfRecentAmisToKeep
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateReplicationJobRequest(
    replicationJobId: ReplicationJobId,
    frequency: Optional[Frequency] = Optional.Absent,
    nextReplicationRunStartTime: Optional[Timestamp] = Optional.Absent,
    licenseType: Optional[zio.aws.sms.model.LicenseType] = Optional.Absent,
    roleName: Optional[RoleName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    numberOfRecentAmisToKeep: Optional[NumberOfRecentAmisToKeep] =
      Optional.Absent,
    encrypted: Optional[Encrypted] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.UpdateReplicationJobRequest = {
    import UpdateReplicationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.UpdateReplicationJobRequest
      .builder()
      .replicationJobId(
        ReplicationJobId.unwrap(replicationJobId): java.lang.String
      )
      .optionallyWith(frequency.map(value => Frequency.unwrap(value): Integer))(
        _.frequency
      )
      .optionallyWith(
        nextReplicationRunStartTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.nextReplicationRunStartTime)
      .optionallyWith(licenseType.map(value => value.unwrap))(_.licenseType)
      .optionallyWith(
        roleName.map(value => RoleName.unwrap(value): java.lang.String)
      )(_.roleName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        numberOfRecentAmisToKeep.map(value =>
          NumberOfRecentAmisToKeep.unwrap(value): Integer
        )
      )(_.numberOfRecentAmisToKeep)
      .optionallyWith(
        encrypted.map(value => Encrypted.unwrap(value): java.lang.Boolean)
      )(_.encrypted)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.UpdateReplicationJobRequest.ReadOnly =
    zio.aws.sms.model.UpdateReplicationJobRequest.wrap(buildAwsValue())
}
object UpdateReplicationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.UpdateReplicationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.UpdateReplicationJobRequest =
      zio.aws.sms.model.UpdateReplicationJobRequest(
        replicationJobId,
        frequency.map(value => value),
        nextReplicationRunStartTime.map(value => value),
        licenseType.map(value => value),
        roleName.map(value => value),
        description.map(value => value),
        numberOfRecentAmisToKeep.map(value => value),
        encrypted.map(value => value),
        kmsKeyId.map(value => value)
      )
    def replicationJobId: ReplicationJobId
    def frequency: Optional[Frequency]
    def nextReplicationRunStartTime: Optional[Timestamp]
    def licenseType: Optional[zio.aws.sms.model.LicenseType]
    def roleName: Optional[RoleName]
    def description: Optional[Description]
    def numberOfRecentAmisToKeep: Optional[NumberOfRecentAmisToKeep]
    def encrypted: Optional[Encrypted]
    def kmsKeyId: Optional[KmsKeyId]
    def getReplicationJobId: ZIO[Any, Nothing, ReplicationJobId] =
      ZIO.succeed(replicationJobId)
    def getFrequency: ZIO[Any, AwsError, Frequency] =
      AwsError.unwrapOptionField("frequency", frequency)
    def getNextReplicationRunStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "nextReplicationRunStartTime",
        nextReplicationRunStartTime
      )
    def getLicenseType: ZIO[Any, AwsError, zio.aws.sms.model.LicenseType] =
      AwsError.unwrapOptionField("licenseType", licenseType)
    def getRoleName: ZIO[Any, AwsError, RoleName] =
      AwsError.unwrapOptionField("roleName", roleName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getNumberOfRecentAmisToKeep
        : ZIO[Any, AwsError, NumberOfRecentAmisToKeep] = AwsError
      .unwrapOptionField("numberOfRecentAmisToKeep", numberOfRecentAmisToKeep)
    def getEncrypted: ZIO[Any, AwsError, Encrypted] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.UpdateReplicationJobRequest
  ) extends zio.aws.sms.model.UpdateReplicationJobRequest.ReadOnly {
    override val replicationJobId: ReplicationJobId =
      zio.aws.sms.model.primitives.ReplicationJobId(impl.replicationJobId())
    override val frequency: Optional[Frequency] = zio.aws.core.internal
      .optionalFromNullable(impl.frequency())
      .map(value => zio.aws.sms.model.primitives.Frequency(value))
    override val nextReplicationRunStartTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextReplicationRunStartTime())
        .map(value => zio.aws.sms.model.primitives.Timestamp(value))
    override val licenseType: Optional[zio.aws.sms.model.LicenseType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licenseType())
        .map(value => zio.aws.sms.model.LicenseType.wrap(value))
    override val roleName: Optional[RoleName] = zio.aws.core.internal
      .optionalFromNullable(impl.roleName())
      .map(value => zio.aws.sms.model.primitives.RoleName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.sms.model.primitives.Description(value))
    override val numberOfRecentAmisToKeep: Optional[NumberOfRecentAmisToKeep] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfRecentAmisToKeep())
        .map(value =>
          zio.aws.sms.model.primitives.NumberOfRecentAmisToKeep(value)
        )
    override val encrypted: Optional[Encrypted] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => zio.aws.sms.model.primitives.Encrypted(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sms.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.UpdateReplicationJobRequest
  ): zio.aws.sms.model.UpdateReplicationJobRequest.ReadOnly = new Wrapper(impl)
}
