package zio.aws.sms.model
import scala.jdk.CollectionConverters._
sealed trait ConnectorCapability {
  def unwrap: software.amazon.awssdk.services.sms.model.ConnectorCapability
}
object ConnectorCapability {
  def wrap(
      value: software.amazon.awssdk.services.sms.model.ConnectorCapability
  ): zio.aws.sms.model.ConnectorCapability = value match {
    case software.amazon.awssdk.services.sms.model.ConnectorCapability.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sms.model.ConnectorCapability.VSPHERE =>
      val r = VSPHERE
      r
    case software.amazon.awssdk.services.sms.model.ConnectorCapability.SCVMM =>
      val r = SCVMM
      r
    case software.amazon.awssdk.services.sms.model.ConnectorCapability.HYPERV_MANAGER =>
      val r = `HYPERV-MANAGER`
      r
    case software.amazon.awssdk.services.sms.model.ConnectorCapability.SNAPSHOT_BATCHING =>
      val r = SNAPSHOT_BATCHING
      r
    case software.amazon.awssdk.services.sms.model.ConnectorCapability.SMS_OPTIMIZED =>
      val r = SMS_OPTIMIZED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sms.model.ConnectorCapability {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ConnectorCapability =
      software.amazon.awssdk.services.sms.model.ConnectorCapability.UNKNOWN_TO_SDK_VERSION
  }
  case object VSPHERE extends zio.aws.sms.model.ConnectorCapability {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ConnectorCapability =
      software.amazon.awssdk.services.sms.model.ConnectorCapability.VSPHERE
  }
  case object SCVMM extends zio.aws.sms.model.ConnectorCapability {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ConnectorCapability =
      software.amazon.awssdk.services.sms.model.ConnectorCapability.SCVMM
  }
  case object `HYPERV-MANAGER` extends zio.aws.sms.model.ConnectorCapability {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ConnectorCapability =
      software.amazon.awssdk.services.sms.model.ConnectorCapability.HYPERV_MANAGER
  }
  case object SNAPSHOT_BATCHING extends zio.aws.sms.model.ConnectorCapability {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ConnectorCapability =
      software.amazon.awssdk.services.sms.model.ConnectorCapability.SNAPSHOT_BATCHING
  }
  case object SMS_OPTIMIZED extends zio.aws.sms.model.ConnectorCapability {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ConnectorCapability =
      software.amazon.awssdk.services.sms.model.ConnectorCapability.SMS_OPTIMIZED
  }
}
