package zio.aws.sms.model
import zio.aws.sms.model.primitives.AppId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GenerateTemplateRequest(
    appId: Optional[AppId] = Optional.Absent,
    templateFormat: Optional[zio.aws.sms.model.OutputFormat] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.GenerateTemplateRequest = {
    import GenerateTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.GenerateTemplateRequest
      .builder()
      .optionallyWith(
        appId.map(value => AppId.unwrap(value): java.lang.String)
      )(_.appId)
      .optionallyWith(templateFormat.map(value => value.unwrap))(
        _.templateFormat
      )
      .build()
  }
  def asReadOnly: zio.aws.sms.model.GenerateTemplateRequest.ReadOnly =
    zio.aws.sms.model.GenerateTemplateRequest.wrap(buildAwsValue())
}
object GenerateTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.GenerateTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.GenerateTemplateRequest =
      zio.aws.sms.model.GenerateTemplateRequest(
        appId.map(value => value),
        templateFormat.map(value => value)
      )
    def appId: Optional[AppId]
    def templateFormat: Optional[zio.aws.sms.model.OutputFormat]
    def getAppId: ZIO[Any, AwsError, AppId] =
      AwsError.unwrapOptionField("appId", appId)
    def getTemplateFormat: ZIO[Any, AwsError, zio.aws.sms.model.OutputFormat] =
      AwsError.unwrapOptionField("templateFormat", templateFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.GenerateTemplateRequest
  ) extends zio.aws.sms.model.GenerateTemplateRequest.ReadOnly {
    override val appId: Optional[AppId] = zio.aws.core.internal
      .optionalFromNullable(impl.appId())
      .map(value => zio.aws.sms.model.primitives.AppId(value))
    override val templateFormat: Optional[zio.aws.sms.model.OutputFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateFormat())
        .map(value => zio.aws.sms.model.OutputFormat.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.GenerateTemplateRequest
  ): zio.aws.sms.model.GenerateTemplateRequest.ReadOnly = new Wrapper(impl)
}
