package zio.aws.sms.model
import zio.aws.sms.model.primitives.AppId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAppRequest(appId: Optional[AppId] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.GetAppRequest = {
    import GetAppRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.GetAppRequest
      .builder()
      .optionallyWith(
        appId.map(value => AppId.unwrap(value): java.lang.String)
      )(_.appId)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.GetAppRequest.ReadOnly =
    zio.aws.sms.model.GetAppRequest.wrap(buildAwsValue())
}
object GetAppRequest {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sms.model.GetAppRequest] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.GetAppRequest =
      zio.aws.sms.model.GetAppRequest(appId.map(value => value))
    def appId: Optional[AppId]
    def getAppId: ZIO[Any, AwsError, AppId] =
      AwsError.unwrapOptionField("appId", appId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.GetAppRequest
  ) extends zio.aws.sms.model.GetAppRequest.ReadOnly {
    override val appId: Optional[AppId] = zio.aws.core.internal
      .optionalFromNullable(impl.appId())
      .map(value => zio.aws.sms.model.primitives.AppId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.GetAppRequest
  ): zio.aws.sms.model.GetAppRequest.ReadOnly = new Wrapper(impl)
}
