package zio.aws.sms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAppResponse(
    appSummary: Optional[zio.aws.sms.model.AppSummary] = Optional.Absent,
    serverGroups: Optional[Iterable[zio.aws.sms.model.ServerGroup]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.sms.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.GetAppResponse = {
    import GetAppResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.GetAppResponse
      .builder()
      .optionallyWith(appSummary.map(value => value.buildAwsValue()))(
        _.appSummary
      )
      .optionallyWith(
        serverGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serverGroups)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.GetAppResponse.ReadOnly =
    zio.aws.sms.model.GetAppResponse.wrap(buildAwsValue())
}
object GetAppResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.GetAppResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.GetAppResponse =
      zio.aws.sms.model.GetAppResponse(
        appSummary.map(value => value.asEditable),
        serverGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def appSummary: Optional[zio.aws.sms.model.AppSummary.ReadOnly]
    def serverGroups: Optional[List[zio.aws.sms.model.ServerGroup.ReadOnly]]
    def tags: Optional[List[zio.aws.sms.model.Tag.ReadOnly]]
    def getAppSummary
        : ZIO[Any, AwsError, zio.aws.sms.model.AppSummary.ReadOnly] =
      AwsError.unwrapOptionField("appSummary", appSummary)
    def getServerGroups
        : ZIO[Any, AwsError, List[zio.aws.sms.model.ServerGroup.ReadOnly]] =
      AwsError.unwrapOptionField("serverGroups", serverGroups)
    def getTags: ZIO[Any, AwsError, List[zio.aws.sms.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.GetAppResponse
  ) extends zio.aws.sms.model.GetAppResponse.ReadOnly {
    override val appSummary: Optional[zio.aws.sms.model.AppSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appSummary())
        .map(value => zio.aws.sms.model.AppSummary.wrap(value))
    override val serverGroups
        : Optional[List[zio.aws.sms.model.ServerGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sms.model.ServerGroup.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.sms.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sms.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.GetAppResponse
  ): zio.aws.sms.model.GetAppResponse.ReadOnly = new Wrapper(impl)
}
