package zio.aws.sms.model
import zio.aws.sms.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetConnectorsResponse(
    connectorList: Optional[Iterable[zio.aws.sms.model.Connector]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.GetConnectorsResponse = {
    import GetConnectorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.GetConnectorsResponse
      .builder()
      .optionallyWith(
        connectorList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connectorList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.GetConnectorsResponse.ReadOnly =
    zio.aws.sms.model.GetConnectorsResponse.wrap(buildAwsValue())
}
object GetConnectorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.GetConnectorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.GetConnectorsResponse =
      zio.aws.sms.model.GetConnectorsResponse(
        connectorList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def connectorList: Optional[List[zio.aws.sms.model.Connector.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getConnectorList
        : ZIO[Any, AwsError, List[zio.aws.sms.model.Connector.ReadOnly]] =
      AwsError.unwrapOptionField("connectorList", connectorList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.GetConnectorsResponse
  ) extends zio.aws.sms.model.GetConnectorsResponse.ReadOnly {
    override val connectorList
        : Optional[List[zio.aws.sms.model.Connector.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sms.model.Connector.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sms.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.GetConnectorsResponse
  ): zio.aws.sms.model.GetConnectorsResponse.ReadOnly = new Wrapper(impl)
}
