package zio.aws.sms.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sms.model.primitives.{
  Frequency,
  RunOnce,
  AmiId,
  ReplicationJobId,
  Timestamp,
  RoleName,
  ReplicationJobStatusMessage,
  ServerId,
  Encrypted,
  KmsKeyId,
  Description,
  NumberOfRecentAmisToKeep
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ReplicationJob(
    replicationJobId: Optional[ReplicationJobId] = Optional.Absent,
    serverId: Optional[ServerId] = Optional.Absent,
    serverType: Optional[zio.aws.sms.model.ServerType] = Optional.Absent,
    vmServer: Optional[zio.aws.sms.model.VmServer] = Optional.Absent,
    seedReplicationTime: Optional[Timestamp] = Optional.Absent,
    frequency: Optional[Frequency] = Optional.Absent,
    runOnce: Optional[RunOnce] = Optional.Absent,
    nextReplicationRunStartTime: Optional[Timestamp] = Optional.Absent,
    licenseType: Optional[zio.aws.sms.model.LicenseType] = Optional.Absent,
    roleName: Optional[RoleName] = Optional.Absent,
    latestAmiId: Optional[AmiId] = Optional.Absent,
    state: Optional[zio.aws.sms.model.ReplicationJobState] = Optional.Absent,
    statusMessage: Optional[ReplicationJobStatusMessage] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    numberOfRecentAmisToKeep: Optional[NumberOfRecentAmisToKeep] =
      Optional.Absent,
    encrypted: Optional[Encrypted] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    replicationRunList: Optional[Iterable[zio.aws.sms.model.ReplicationRun]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.ReplicationJob = {
    import ReplicationJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.ReplicationJob
      .builder()
      .optionallyWith(
        replicationJobId.map(value =>
          ReplicationJobId.unwrap(value): java.lang.String
        )
      )(_.replicationJobId)
      .optionallyWith(
        serverId.map(value => ServerId.unwrap(value): java.lang.String)
      )(_.serverId)
      .optionallyWith(serverType.map(value => value.unwrap))(_.serverType)
      .optionallyWith(vmServer.map(value => value.buildAwsValue()))(_.vmServer)
      .optionallyWith(
        seedReplicationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.seedReplicationTime)
      .optionallyWith(frequency.map(value => Frequency.unwrap(value): Integer))(
        _.frequency
      )
      .optionallyWith(
        runOnce.map(value => RunOnce.unwrap(value): java.lang.Boolean)
      )(_.runOnce)
      .optionallyWith(
        nextReplicationRunStartTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.nextReplicationRunStartTime)
      .optionallyWith(licenseType.map(value => value.unwrap))(_.licenseType)
      .optionallyWith(
        roleName.map(value => RoleName.unwrap(value): java.lang.String)
      )(_.roleName)
      .optionallyWith(
        latestAmiId.map(value => AmiId.unwrap(value): java.lang.String)
      )(_.latestAmiId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        statusMessage.map(value =>
          ReplicationJobStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        numberOfRecentAmisToKeep.map(value =>
          NumberOfRecentAmisToKeep.unwrap(value): Integer
        )
      )(_.numberOfRecentAmisToKeep)
      .optionallyWith(
        encrypted.map(value => Encrypted.unwrap(value): java.lang.Boolean)
      )(_.encrypted)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        replicationRunList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationRunList)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.ReplicationJob.ReadOnly =
    zio.aws.sms.model.ReplicationJob.wrap(buildAwsValue())
}
object ReplicationJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.ReplicationJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.ReplicationJob =
      zio.aws.sms.model.ReplicationJob(
        replicationJobId.map(value => value),
        serverId.map(value => value),
        serverType.map(value => value),
        vmServer.map(value => value.asEditable),
        seedReplicationTime.map(value => value),
        frequency.map(value => value),
        runOnce.map(value => value),
        nextReplicationRunStartTime.map(value => value),
        licenseType.map(value => value),
        roleName.map(value => value),
        latestAmiId.map(value => value),
        state.map(value => value),
        statusMessage.map(value => value),
        description.map(value => value),
        numberOfRecentAmisToKeep.map(value => value),
        encrypted.map(value => value),
        kmsKeyId.map(value => value),
        replicationRunList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def replicationJobId: Optional[ReplicationJobId]
    def serverId: Optional[ServerId]
    def serverType: Optional[zio.aws.sms.model.ServerType]
    def vmServer: Optional[zio.aws.sms.model.VmServer.ReadOnly]
    def seedReplicationTime: Optional[Timestamp]
    def frequency: Optional[Frequency]
    def runOnce: Optional[RunOnce]
    def nextReplicationRunStartTime: Optional[Timestamp]
    def licenseType: Optional[zio.aws.sms.model.LicenseType]
    def roleName: Optional[RoleName]
    def latestAmiId: Optional[AmiId]
    def state: Optional[zio.aws.sms.model.ReplicationJobState]
    def statusMessage: Optional[ReplicationJobStatusMessage]
    def description: Optional[Description]
    def numberOfRecentAmisToKeep: Optional[NumberOfRecentAmisToKeep]
    def encrypted: Optional[Encrypted]
    def kmsKeyId: Optional[KmsKeyId]
    def replicationRunList
        : Optional[List[zio.aws.sms.model.ReplicationRun.ReadOnly]]
    def getReplicationJobId: ZIO[Any, AwsError, ReplicationJobId] =
      AwsError.unwrapOptionField("replicationJobId", replicationJobId)
    def getServerId: ZIO[Any, AwsError, ServerId] =
      AwsError.unwrapOptionField("serverId", serverId)
    def getServerType: ZIO[Any, AwsError, zio.aws.sms.model.ServerType] =
      AwsError.unwrapOptionField("serverType", serverType)
    def getVmServer: ZIO[Any, AwsError, zio.aws.sms.model.VmServer.ReadOnly] =
      AwsError.unwrapOptionField("vmServer", vmServer)
    def getSeedReplicationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("seedReplicationTime", seedReplicationTime)
    def getFrequency: ZIO[Any, AwsError, Frequency] =
      AwsError.unwrapOptionField("frequency", frequency)
    def getRunOnce: ZIO[Any, AwsError, RunOnce] =
      AwsError.unwrapOptionField("runOnce", runOnce)
    def getNextReplicationRunStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "nextReplicationRunStartTime",
        nextReplicationRunStartTime
      )
    def getLicenseType: ZIO[Any, AwsError, zio.aws.sms.model.LicenseType] =
      AwsError.unwrapOptionField("licenseType", licenseType)
    def getRoleName: ZIO[Any, AwsError, RoleName] =
      AwsError.unwrapOptionField("roleName", roleName)
    def getLatestAmiId: ZIO[Any, AwsError, AmiId] =
      AwsError.unwrapOptionField("latestAmiId", latestAmiId)
    def getState: ZIO[Any, AwsError, zio.aws.sms.model.ReplicationJobState] =
      AwsError.unwrapOptionField("state", state)
    def getStatusMessage: ZIO[Any, AwsError, ReplicationJobStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getNumberOfRecentAmisToKeep
        : ZIO[Any, AwsError, NumberOfRecentAmisToKeep] = AwsError
      .unwrapOptionField("numberOfRecentAmisToKeep", numberOfRecentAmisToKeep)
    def getEncrypted: ZIO[Any, AwsError, Encrypted] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getReplicationRunList
        : ZIO[Any, AwsError, List[zio.aws.sms.model.ReplicationRun.ReadOnly]] =
      AwsError.unwrapOptionField("replicationRunList", replicationRunList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.ReplicationJob
  ) extends zio.aws.sms.model.ReplicationJob.ReadOnly {
    override val replicationJobId: Optional[ReplicationJobId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationJobId())
        .map(value => zio.aws.sms.model.primitives.ReplicationJobId(value))
    override val serverId: Optional[ServerId] = zio.aws.core.internal
      .optionalFromNullable(impl.serverId())
      .map(value => zio.aws.sms.model.primitives.ServerId(value))
    override val serverType: Optional[zio.aws.sms.model.ServerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverType())
        .map(value => zio.aws.sms.model.ServerType.wrap(value))
    override val vmServer: Optional[zio.aws.sms.model.VmServer.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vmServer())
        .map(value => zio.aws.sms.model.VmServer.wrap(value))
    override val seedReplicationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.seedReplicationTime())
        .map(value => zio.aws.sms.model.primitives.Timestamp(value))
    override val frequency: Optional[Frequency] = zio.aws.core.internal
      .optionalFromNullable(impl.frequency())
      .map(value => zio.aws.sms.model.primitives.Frequency(value))
    override val runOnce: Optional[RunOnce] = zio.aws.core.internal
      .optionalFromNullable(impl.runOnce())
      .map(value => zio.aws.sms.model.primitives.RunOnce(value))
    override val nextReplicationRunStartTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextReplicationRunStartTime())
        .map(value => zio.aws.sms.model.primitives.Timestamp(value))
    override val licenseType: Optional[zio.aws.sms.model.LicenseType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licenseType())
        .map(value => zio.aws.sms.model.LicenseType.wrap(value))
    override val roleName: Optional[RoleName] = zio.aws.core.internal
      .optionalFromNullable(impl.roleName())
      .map(value => zio.aws.sms.model.primitives.RoleName(value))
    override val latestAmiId: Optional[AmiId] = zio.aws.core.internal
      .optionalFromNullable(impl.latestAmiId())
      .map(value => zio.aws.sms.model.primitives.AmiId(value))
    override val state: Optional[zio.aws.sms.model.ReplicationJobState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.sms.model.ReplicationJobState.wrap(value))
    override val statusMessage: Optional[ReplicationJobStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.sms.model.primitives.ReplicationJobStatusMessage(value)
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.sms.model.primitives.Description(value))
    override val numberOfRecentAmisToKeep: Optional[NumberOfRecentAmisToKeep] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfRecentAmisToKeep())
        .map(value =>
          zio.aws.sms.model.primitives.NumberOfRecentAmisToKeep(value)
        )
    override val encrypted: Optional[Encrypted] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => zio.aws.sms.model.primitives.Encrypted(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sms.model.primitives.KmsKeyId(value))
    override val replicationRunList
        : Optional[List[zio.aws.sms.model.ReplicationRun.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationRunList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sms.model.ReplicationRun.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.ReplicationJob
  ): zio.aws.sms.model.ReplicationJob.ReadOnly = new Wrapper(impl)
}
