package zio.aws.sms
import zio.aws.sms.model.DeleteAppResponse.ReadOnly
import software.amazon.awssdk.services.sms.SmsAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.sms.model.{
  CreateAppRequest,
  GetReplicationJobsRequest,
  NotifyAppValidationOutputRequest,
  GenerateChangeSetRequest,
  UpdateAppRequest,
  StartAppReplicationRequest,
  DeleteAppReplicationConfigurationRequest,
  GetAppValidationOutputRequest,
  GenerateTemplateRequest,
  DeleteAppValidationConfigurationRequest,
  CreateReplicationJobRequest,
  DisassociateConnectorRequest,
  GetAppValidationConfigurationRequest,
  GetAppLaunchConfigurationRequest,
  DeleteAppLaunchConfigurationRequest,
  GetAppReplicationConfigurationRequest,
  DeleteServerCatalogRequest,
  GetServersRequest,
  LaunchAppRequest,
  ImportAppCatalogRequest,
  PutAppLaunchConfigurationRequest,
  GetAppRequest,
  ImportServerCatalogRequest,
  UpdateReplicationJobRequest,
  GetConnectorsRequest,
  DeleteReplicationJobRequest,
  GetReplicationRunsRequest,
  ListAppsRequest,
  StartOnDemandReplicationRunRequest,
  StartOnDemandAppReplicationRequest,
  TerminateAppRequest,
  DeleteAppRequest,
  PutAppValidationConfigurationRequest,
  PutAppReplicationConfigurationRequest,
  StopAppReplicationRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object SmsMock extends Mock[Sms] {
  object GetReplicationRuns
      extends Stream[
        GetReplicationRunsRequest,
        AwsError,
        zio.aws.sms.model.ReplicationRun.ReadOnly
      ]
  object GetReplicationRunsPaginated
      extends Effect[
        GetReplicationRunsRequest,
        AwsError,
        zio.aws.sms.model.GetReplicationRunsResponse.ReadOnly
      ]
  object PutAppValidationConfiguration
      extends Effect[
        PutAppValidationConfigurationRequest,
        AwsError,
        zio.aws.sms.model.PutAppValidationConfigurationResponse.ReadOnly
      ]
  object PutAppLaunchConfiguration
      extends Effect[
        PutAppLaunchConfigurationRequest,
        AwsError,
        zio.aws.sms.model.PutAppLaunchConfigurationResponse.ReadOnly
      ]
  object ImportAppCatalog
      extends Effect[
        ImportAppCatalogRequest,
        AwsError,
        zio.aws.sms.model.ImportAppCatalogResponse.ReadOnly
      ]
  object GenerateChangeSet
      extends Effect[
        GenerateChangeSetRequest,
        AwsError,
        zio.aws.sms.model.GenerateChangeSetResponse.ReadOnly
      ]
  object GetApp
      extends Effect[
        GetAppRequest,
        AwsError,
        zio.aws.sms.model.GetAppResponse.ReadOnly
      ]
  object StartOnDemandReplicationRun
      extends Effect[
        StartOnDemandReplicationRunRequest,
        AwsError,
        zio.aws.sms.model.StartOnDemandReplicationRunResponse.ReadOnly
      ]
  object StartAppReplication
      extends Effect[
        StartAppReplicationRequest,
        AwsError,
        zio.aws.sms.model.StartAppReplicationResponse.ReadOnly
      ]
  object ListApps
      extends Effect[
        ListAppsRequest,
        AwsError,
        zio.aws.sms.model.ListAppsResponse.ReadOnly
      ]
  object GetAppValidationOutput
      extends Effect[
        GetAppValidationOutputRequest,
        AwsError,
        zio.aws.sms.model.GetAppValidationOutputResponse.ReadOnly
      ]
  object GetConnectors
      extends Stream[
        GetConnectorsRequest,
        AwsError,
        zio.aws.sms.model.Connector.ReadOnly
      ]
  object GetConnectorsPaginated
      extends Effect[
        GetConnectorsRequest,
        AwsError,
        zio.aws.sms.model.GetConnectorsResponse.ReadOnly
      ]
  object StopAppReplication
      extends Effect[
        StopAppReplicationRequest,
        AwsError,
        zio.aws.sms.model.StopAppReplicationResponse.ReadOnly
      ]
  object GetAppLaunchConfiguration
      extends Effect[
        GetAppLaunchConfigurationRequest,
        AwsError,
        zio.aws.sms.model.GetAppLaunchConfigurationResponse.ReadOnly
      ]
  object UpdateApp
      extends Effect[
        UpdateAppRequest,
        AwsError,
        zio.aws.sms.model.UpdateAppResponse.ReadOnly
      ]
  object PutAppReplicationConfiguration
      extends Effect[
        PutAppReplicationConfigurationRequest,
        AwsError,
        zio.aws.sms.model.PutAppReplicationConfigurationResponse.ReadOnly
      ]
  object DeleteReplicationJob
      extends Effect[
        DeleteReplicationJobRequest,
        AwsError,
        zio.aws.sms.model.DeleteReplicationJobResponse.ReadOnly
      ]
  object CreateApp
      extends Effect[
        CreateAppRequest,
        AwsError,
        zio.aws.sms.model.CreateAppResponse.ReadOnly
      ]
  object LaunchApp
      extends Effect[
        LaunchAppRequest,
        AwsError,
        zio.aws.sms.model.LaunchAppResponse.ReadOnly
      ]
  object DeleteApp extends Effect[DeleteAppRequest, AwsError, ReadOnly]
  object GetAppValidationConfiguration
      extends Effect[
        GetAppValidationConfigurationRequest,
        AwsError,
        zio.aws.sms.model.GetAppValidationConfigurationResponse.ReadOnly
      ]
  object NotifyAppValidationOutput
      extends Effect[
        NotifyAppValidationOutputRequest,
        AwsError,
        zio.aws.sms.model.NotifyAppValidationOutputResponse.ReadOnly
      ]
  object UpdateReplicationJob
      extends Effect[
        UpdateReplicationJobRequest,
        AwsError,
        zio.aws.sms.model.UpdateReplicationJobResponse.ReadOnly
      ]
  object DeleteAppValidationConfiguration
      extends Effect[
        DeleteAppValidationConfigurationRequest,
        AwsError,
        zio.aws.sms.model.DeleteAppValidationConfigurationResponse.ReadOnly
      ]
  object ImportServerCatalog
      extends Effect[
        ImportServerCatalogRequest,
        AwsError,
        zio.aws.sms.model.ImportServerCatalogResponse.ReadOnly
      ]
  object DeleteServerCatalog
      extends Effect[
        DeleteServerCatalogRequest,
        AwsError,
        zio.aws.sms.model.DeleteServerCatalogResponse.ReadOnly
      ]
  object GenerateTemplate
      extends Effect[
        GenerateTemplateRequest,
        AwsError,
        zio.aws.sms.model.GenerateTemplateResponse.ReadOnly
      ]
  object CreateReplicationJob
      extends Effect[
        CreateReplicationJobRequest,
        AwsError,
        zio.aws.sms.model.CreateReplicationJobResponse.ReadOnly
      ]
  object TerminateApp
      extends Effect[
        TerminateAppRequest,
        AwsError,
        zio.aws.sms.model.TerminateAppResponse.ReadOnly
      ]
  object DeleteAppReplicationConfiguration
      extends Effect[
        DeleteAppReplicationConfigurationRequest,
        AwsError,
        zio.aws.sms.model.DeleteAppReplicationConfigurationResponse.ReadOnly
      ]
  object DeleteAppLaunchConfiguration
      extends Effect[
        DeleteAppLaunchConfigurationRequest,
        AwsError,
        zio.aws.sms.model.DeleteAppLaunchConfigurationResponse.ReadOnly
      ]
  object StartOnDemandAppReplication
      extends Effect[
        StartOnDemandAppReplicationRequest,
        AwsError,
        zio.aws.sms.model.StartOnDemandAppReplicationResponse.ReadOnly
      ]
  object GetAppReplicationConfiguration
      extends Effect[
        GetAppReplicationConfigurationRequest,
        AwsError,
        zio.aws.sms.model.GetAppReplicationConfigurationResponse.ReadOnly
      ]
  object DisassociateConnector
      extends Effect[
        DisassociateConnectorRequest,
        AwsError,
        zio.aws.sms.model.DisassociateConnectorResponse.ReadOnly
      ]
  object GetServers
      extends Stream[
        GetServersRequest,
        AwsError,
        zio.aws.sms.model.Server.ReadOnly
      ]
  object GetServersPaginated
      extends Effect[
        GetServersRequest,
        AwsError,
        zio.aws.sms.model.GetServersResponse.ReadOnly
      ]
  object GetReplicationJobs
      extends Stream[
        GetReplicationJobsRequest,
        AwsError,
        zio.aws.sms.model.ReplicationJob.ReadOnly
      ]
  object GetReplicationJobsPaginated
      extends Effect[
        GetReplicationJobsRequest,
        AwsError,
        zio.aws.sms.model.GetReplicationJobsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Sms] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Sms] { rts =>
        zio.ZIO.succeed {
          new Sms {
            val api: SmsAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Sms = this
            def getReplicationRuns(request: GetReplicationRunsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sms.model.ReplicationRun.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetReplicationRuns, request)
                }
                .getOrThrowFiberFailure()
            }
            def getReplicationRunsPaginated(
                request: GetReplicationRunsRequest
            ): IO[
              AwsError,
              zio.aws.sms.model.GetReplicationRunsResponse.ReadOnly
            ] = proxy(GetReplicationRunsPaginated, request)
            def putAppValidationConfiguration(
                request: PutAppValidationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.sms.model.PutAppValidationConfigurationResponse.ReadOnly
            ] = proxy(PutAppValidationConfiguration, request)
            def putAppLaunchConfiguration(
                request: PutAppLaunchConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.sms.model.PutAppLaunchConfigurationResponse.ReadOnly
            ] = proxy(PutAppLaunchConfiguration, request)
            def importAppCatalog(request: ImportAppCatalogRequest): IO[
              AwsError,
              zio.aws.sms.model.ImportAppCatalogResponse.ReadOnly
            ] = proxy(ImportAppCatalog, request)
            def generateChangeSet(request: GenerateChangeSetRequest): IO[
              AwsError,
              zio.aws.sms.model.GenerateChangeSetResponse.ReadOnly
            ] = proxy(GenerateChangeSet, request)
            def getApp(
                request: GetAppRequest
            ): IO[AwsError, zio.aws.sms.model.GetAppResponse.ReadOnly] =
              proxy(GetApp, request)
            def startOnDemandReplicationRun(
                request: StartOnDemandReplicationRunRequest
            ): IO[
              AwsError,
              zio.aws.sms.model.StartOnDemandReplicationRunResponse.ReadOnly
            ] = proxy(StartOnDemandReplicationRun, request)
            def startAppReplication(request: StartAppReplicationRequest): IO[
              AwsError,
              zio.aws.sms.model.StartAppReplicationResponse.ReadOnly
            ] = proxy(StartAppReplication, request)
            def listApps(
                request: ListAppsRequest
            ): IO[AwsError, zio.aws.sms.model.ListAppsResponse.ReadOnly] =
              proxy(ListApps, request)
            def getAppValidationOutput(
                request: GetAppValidationOutputRequest
            ): IO[
              AwsError,
              zio.aws.sms.model.GetAppValidationOutputResponse.ReadOnly
            ] = proxy(GetAppValidationOutput, request)
            def getConnectors(
                request: GetConnectorsRequest
            ): ZStream[Any, AwsError, zio.aws.sms.model.Connector.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(GetConnectors, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def getConnectorsPaginated(
                request: GetConnectorsRequest
            ): IO[AwsError, zio.aws.sms.model.GetConnectorsResponse.ReadOnly] =
              proxy(GetConnectorsPaginated, request)
            def stopAppReplication(request: StopAppReplicationRequest): IO[
              AwsError,
              zio.aws.sms.model.StopAppReplicationResponse.ReadOnly
            ] = proxy(StopAppReplication, request)
            def getAppLaunchConfiguration(
                request: GetAppLaunchConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.sms.model.GetAppLaunchConfigurationResponse.ReadOnly
            ] = proxy(GetAppLaunchConfiguration, request)
            def updateApp(
                request: UpdateAppRequest
            ): IO[AwsError, zio.aws.sms.model.UpdateAppResponse.ReadOnly] =
              proxy(UpdateApp, request)
            def putAppReplicationConfiguration(
                request: PutAppReplicationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.sms.model.PutAppReplicationConfigurationResponse.ReadOnly
            ] = proxy(PutAppReplicationConfiguration, request)
            def deleteReplicationJob(request: DeleteReplicationJobRequest): IO[
              AwsError,
              zio.aws.sms.model.DeleteReplicationJobResponse.ReadOnly
            ] = proxy(DeleteReplicationJob, request)
            def createApp(
                request: CreateAppRequest
            ): IO[AwsError, zio.aws.sms.model.CreateAppResponse.ReadOnly] =
              proxy(CreateApp, request)
            def launchApp(
                request: LaunchAppRequest
            ): IO[AwsError, zio.aws.sms.model.LaunchAppResponse.ReadOnly] =
              proxy(LaunchApp, request)
            def deleteApp(request: DeleteAppRequest): IO[AwsError, ReadOnly] =
              proxy(DeleteApp, request)
            def getAppValidationConfiguration(
                request: GetAppValidationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.sms.model.GetAppValidationConfigurationResponse.ReadOnly
            ] = proxy(GetAppValidationConfiguration, request)
            def notifyAppValidationOutput(
                request: NotifyAppValidationOutputRequest
            ): IO[
              AwsError,
              zio.aws.sms.model.NotifyAppValidationOutputResponse.ReadOnly
            ] = proxy(NotifyAppValidationOutput, request)
            def updateReplicationJob(request: UpdateReplicationJobRequest): IO[
              AwsError,
              zio.aws.sms.model.UpdateReplicationJobResponse.ReadOnly
            ] = proxy(UpdateReplicationJob, request)
            def deleteAppValidationConfiguration(
                request: DeleteAppValidationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.sms.model.DeleteAppValidationConfigurationResponse.ReadOnly
            ] = proxy(DeleteAppValidationConfiguration, request)
            def importServerCatalog(request: ImportServerCatalogRequest): IO[
              AwsError,
              zio.aws.sms.model.ImportServerCatalogResponse.ReadOnly
            ] = proxy(ImportServerCatalog, request)
            def deleteServerCatalog(request: DeleteServerCatalogRequest): IO[
              AwsError,
              zio.aws.sms.model.DeleteServerCatalogResponse.ReadOnly
            ] = proxy(DeleteServerCatalog, request)
            def generateTemplate(request: GenerateTemplateRequest): IO[
              AwsError,
              zio.aws.sms.model.GenerateTemplateResponse.ReadOnly
            ] = proxy(GenerateTemplate, request)
            def createReplicationJob(request: CreateReplicationJobRequest): IO[
              AwsError,
              zio.aws.sms.model.CreateReplicationJobResponse.ReadOnly
            ] = proxy(CreateReplicationJob, request)
            def terminateApp(
                request: TerminateAppRequest
            ): IO[AwsError, zio.aws.sms.model.TerminateAppResponse.ReadOnly] =
              proxy(TerminateApp, request)
            def deleteAppReplicationConfiguration(
                request: DeleteAppReplicationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.sms.model.DeleteAppReplicationConfigurationResponse.ReadOnly
            ] = proxy(DeleteAppReplicationConfiguration, request)
            def deleteAppLaunchConfiguration(
                request: DeleteAppLaunchConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.sms.model.DeleteAppLaunchConfigurationResponse.ReadOnly
            ] = proxy(DeleteAppLaunchConfiguration, request)
            def startOnDemandAppReplication(
                request: StartOnDemandAppReplicationRequest
            ): IO[
              AwsError,
              zio.aws.sms.model.StartOnDemandAppReplicationResponse.ReadOnly
            ] = proxy(StartOnDemandAppReplication, request)
            def getAppReplicationConfiguration(
                request: GetAppReplicationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.sms.model.GetAppReplicationConfigurationResponse.ReadOnly
            ] = proxy(GetAppReplicationConfiguration, request)
            def disassociateConnector(
                request: DisassociateConnectorRequest
            ): IO[
              AwsError,
              zio.aws.sms.model.DisassociateConnectorResponse.ReadOnly
            ] = proxy(DisassociateConnector, request)
            def getServers(
                request: GetServersRequest
            ): ZStream[Any, AwsError, zio.aws.sms.model.Server.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(GetServers, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def getServersPaginated(
                request: GetServersRequest
            ): IO[AwsError, zio.aws.sms.model.GetServersResponse.ReadOnly] =
              proxy(GetServersPaginated, request)
            def getReplicationJobs(request: GetReplicationJobsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sms.model.ReplicationJob.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetReplicationJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def getReplicationJobsPaginated(
                request: GetReplicationJobsRequest
            ): IO[
              AwsError,
              zio.aws.sms.model.GetReplicationJobsResponse.ReadOnly
            ] = proxy(GetReplicationJobsPaginated, request)
          }
        }
      }
    }
  }
}
