package zio.aws.sms.model
import zio.aws.sms.model.primitives.{
  ClientToken,
  RoleName,
  AppDescription,
  AppName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAppRequest(
    name: Optional[AppName] = Optional.Absent,
    description: Optional[AppDescription] = Optional.Absent,
    roleName: Optional[RoleName] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    serverGroups: Optional[Iterable[zio.aws.sms.model.ServerGroup]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.sms.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.CreateAppRequest = {
    import CreateAppRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.CreateAppRequest
      .builder()
      .optionallyWith(
        name.map(value => AppName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => AppDescription.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        roleName.map(value => RoleName.unwrap(value): java.lang.String)
      )(_.roleName)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        serverGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serverGroups)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.CreateAppRequest.ReadOnly =
    zio.aws.sms.model.CreateAppRequest.wrap(buildAwsValue())
}
object CreateAppRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.CreateAppRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.CreateAppRequest =
      zio.aws.sms.model.CreateAppRequest(
        name.map(value => value),
        description.map(value => value),
        roleName.map(value => value),
        clientToken.map(value => value),
        serverGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Optional[AppName]
    def description: Optional[AppDescription]
    def roleName: Optional[RoleName]
    def clientToken: Optional[ClientToken]
    def serverGroups: Optional[List[zio.aws.sms.model.ServerGroup.ReadOnly]]
    def tags: Optional[List[zio.aws.sms.model.Tag.ReadOnly]]
    def getName: ZIO[Any, AwsError, AppName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, AppDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRoleName: ZIO[Any, AwsError, RoleName] =
      AwsError.unwrapOptionField("roleName", roleName)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getServerGroups
        : ZIO[Any, AwsError, List[zio.aws.sms.model.ServerGroup.ReadOnly]] =
      AwsError.unwrapOptionField("serverGroups", serverGroups)
    def getTags: ZIO[Any, AwsError, List[zio.aws.sms.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.CreateAppRequest
  ) extends zio.aws.sms.model.CreateAppRequest.ReadOnly {
    override val name: Optional[AppName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.sms.model.primitives.AppName(value))
    override val description: Optional[AppDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.sms.model.primitives.AppDescription(value))
    override val roleName: Optional[RoleName] = zio.aws.core.internal
      .optionalFromNullable(impl.roleName())
      .map(value => zio.aws.sms.model.primitives.RoleName(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.sms.model.primitives.ClientToken(value))
    override val serverGroups
        : Optional[List[zio.aws.sms.model.ServerGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sms.model.ServerGroup.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.sms.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sms.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.CreateAppRequest
  ): zio.aws.sms.model.CreateAppRequest.ReadOnly = new Wrapper(impl)
}
