package zio.aws.sms.model
import zio.aws.sms.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetReplicationJobsResponse(
    replicationJobList: Optional[Iterable[zio.aws.sms.model.ReplicationJob]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.GetReplicationJobsResponse = {
    import GetReplicationJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.GetReplicationJobsResponse
      .builder()
      .optionallyWith(
        replicationJobList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationJobList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.GetReplicationJobsResponse.ReadOnly =
    zio.aws.sms.model.GetReplicationJobsResponse.wrap(buildAwsValue())
}
object GetReplicationJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.GetReplicationJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.GetReplicationJobsResponse =
      zio.aws.sms.model.GetReplicationJobsResponse(
        replicationJobList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def replicationJobList
        : Optional[List[zio.aws.sms.model.ReplicationJob.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getReplicationJobList
        : ZIO[Any, AwsError, List[zio.aws.sms.model.ReplicationJob.ReadOnly]] =
      AwsError.unwrapOptionField("replicationJobList", replicationJobList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.GetReplicationJobsResponse
  ) extends zio.aws.sms.model.GetReplicationJobsResponse.ReadOnly {
    override val replicationJobList
        : Optional[List[zio.aws.sms.model.ReplicationJob.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationJobList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sms.model.ReplicationJob.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sms.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.GetReplicationJobsResponse
  ): zio.aws.sms.model.GetReplicationJobsResponse.ReadOnly = new Wrapper(impl)
}
