package zio.aws.sms.model
import zio.aws.sms.model.primitives.{ServerGroupName, ServerGroupId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServerGroup(
    serverGroupId: Optional[ServerGroupId] = Optional.Absent,
    name: Optional[ServerGroupName] = Optional.Absent,
    serverList: Optional[Iterable[zio.aws.sms.model.Server]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.sms.model.ServerGroup = {
    import ServerGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.ServerGroup
      .builder()
      .optionallyWith(
        serverGroupId.map(value =>
          ServerGroupId.unwrap(value): java.lang.String
        )
      )(_.serverGroupId)
      .optionallyWith(
        name.map(value => ServerGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        serverList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serverList)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.ServerGroup.ReadOnly =
    zio.aws.sms.model.ServerGroup.wrap(buildAwsValue())
}
object ServerGroup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sms.model.ServerGroup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.ServerGroup =
      zio.aws.sms.model.ServerGroup(
        serverGroupId.map(value => value),
        name.map(value => value),
        serverList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serverGroupId: Optional[ServerGroupId]
    def name: Optional[ServerGroupName]
    def serverList: Optional[List[zio.aws.sms.model.Server.ReadOnly]]
    def getServerGroupId: ZIO[Any, AwsError, ServerGroupId] =
      AwsError.unwrapOptionField("serverGroupId", serverGroupId)
    def getName: ZIO[Any, AwsError, ServerGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getServerList
        : ZIO[Any, AwsError, List[zio.aws.sms.model.Server.ReadOnly]] =
      AwsError.unwrapOptionField("serverList", serverList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.ServerGroup
  ) extends zio.aws.sms.model.ServerGroup.ReadOnly {
    override val serverGroupId: Optional[ServerGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.serverGroupId())
      .map(value => zio.aws.sms.model.primitives.ServerGroupId(value))
    override val name: Optional[ServerGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.sms.model.primitives.ServerGroupName(value))
    override val serverList: Optional[List[zio.aws.sms.model.Server.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sms.model.Server.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.ServerGroup
  ): zio.aws.sms.model.ServerGroup.ReadOnly = new Wrapper(impl)
}
