package zio.aws.sms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserDataValidationParameters(
    source: Optional[zio.aws.sms.model.Source] = Optional.Absent,
    scriptType: Optional[zio.aws.sms.model.ScriptType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.UserDataValidationParameters = {
    import UserDataValidationParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.UserDataValidationParameters
      .builder()
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(scriptType.map(value => value.unwrap))(_.scriptType)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.UserDataValidationParameters.ReadOnly =
    zio.aws.sms.model.UserDataValidationParameters.wrap(buildAwsValue())
}
object UserDataValidationParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.UserDataValidationParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.UserDataValidationParameters =
      zio.aws.sms.model.UserDataValidationParameters(
        source.map(value => value.asEditable),
        scriptType.map(value => value)
      )
    def source: Optional[zio.aws.sms.model.Source.ReadOnly]
    def scriptType: Optional[zio.aws.sms.model.ScriptType]
    def getSource: ZIO[Any, AwsError, zio.aws.sms.model.Source.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getScriptType: ZIO[Any, AwsError, zio.aws.sms.model.ScriptType] =
      AwsError.unwrapOptionField("scriptType", scriptType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.UserDataValidationParameters
  ) extends zio.aws.sms.model.UserDataValidationParameters.ReadOnly {
    override val source: Optional[zio.aws.sms.model.Source.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.sms.model.Source.wrap(value))
    override val scriptType: Optional[zio.aws.sms.model.ScriptType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scriptType())
        .map(value => zio.aws.sms.model.ScriptType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.UserDataValidationParameters
  ): zio.aws.sms.model.UserDataValidationParameters.ReadOnly = new Wrapper(impl)
}
