package zio.aws.sms.model
import zio.aws.sms.model.primitives.ReplicationJobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteReplicationJobRequest(
    replicationJobId: ReplicationJobId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.DeleteReplicationJobRequest = {
    import DeleteReplicationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.DeleteReplicationJobRequest
      .builder()
      .replicationJobId(
        ReplicationJobId.unwrap(replicationJobId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sms.model.DeleteReplicationJobRequest.ReadOnly =
    zio.aws.sms.model.DeleteReplicationJobRequest.wrap(buildAwsValue())
}
object DeleteReplicationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.DeleteReplicationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.DeleteReplicationJobRequest =
      zio.aws.sms.model.DeleteReplicationJobRequest(replicationJobId)
    def replicationJobId: ReplicationJobId
    def getReplicationJobId: ZIO[Any, Nothing, ReplicationJobId] =
      ZIO.succeed(replicationJobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.DeleteReplicationJobRequest
  ) extends zio.aws.sms.model.DeleteReplicationJobRequest.ReadOnly {
    override val replicationJobId: ReplicationJobId =
      zio.aws.sms.model.primitives.ReplicationJobId(impl.replicationJobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.DeleteReplicationJobRequest
  ): zio.aws.sms.model.DeleteReplicationJobRequest.ReadOnly = new Wrapper(impl)
}
