package zio.aws.sms.model
import zio.aws.sms.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetReplicationRunsResponse(
    replicationJob: Optional[zio.aws.sms.model.ReplicationJob] =
      Optional.Absent,
    replicationRunList: Optional[Iterable[zio.aws.sms.model.ReplicationRun]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.GetReplicationRunsResponse = {
    import GetReplicationRunsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.GetReplicationRunsResponse
      .builder()
      .optionallyWith(replicationJob.map(value => value.buildAwsValue()))(
        _.replicationJob
      )
      .optionallyWith(
        replicationRunList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationRunList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.GetReplicationRunsResponse.ReadOnly =
    zio.aws.sms.model.GetReplicationRunsResponse.wrap(buildAwsValue())
}
object GetReplicationRunsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.GetReplicationRunsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.GetReplicationRunsResponse =
      zio.aws.sms.model.GetReplicationRunsResponse(
        replicationJob.map(value => value.asEditable),
        replicationRunList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def replicationJob: Optional[zio.aws.sms.model.ReplicationJob.ReadOnly]
    def replicationRunList
        : Optional[List[zio.aws.sms.model.ReplicationRun.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getReplicationJob
        : ZIO[Any, AwsError, zio.aws.sms.model.ReplicationJob.ReadOnly] =
      AwsError.unwrapOptionField("replicationJob", replicationJob)
    def getReplicationRunList
        : ZIO[Any, AwsError, List[zio.aws.sms.model.ReplicationRun.ReadOnly]] =
      AwsError.unwrapOptionField("replicationRunList", replicationRunList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.GetReplicationRunsResponse
  ) extends zio.aws.sms.model.GetReplicationRunsResponse.ReadOnly {
    override val replicationJob
        : Optional[zio.aws.sms.model.ReplicationJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationJob())
        .map(value => zio.aws.sms.model.ReplicationJob.wrap(value))
    override val replicationRunList
        : Optional[List[zio.aws.sms.model.ReplicationRun.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationRunList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sms.model.ReplicationRun.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sms.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.GetReplicationRunsResponse
  ): zio.aws.sms.model.GetReplicationRunsResponse.ReadOnly = new Wrapper(impl)
}
