package zio.aws.sms.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sms.model.primitives.{NextToken, Timestamp}
import scala.jdk.CollectionConverters._
final case class GetServersResponse(
    lastModifiedOn: Optional[Timestamp] = Optional.Absent,
    serverCatalogStatus: Optional[zio.aws.sms.model.ServerCatalogStatus] =
      Optional.Absent,
    serverList: Optional[Iterable[zio.aws.sms.model.Server]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.GetServersResponse = {
    import GetServersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.GetServersResponse
      .builder()
      .optionallyWith(
        lastModifiedOn.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedOn)
      .optionallyWith(serverCatalogStatus.map(value => value.unwrap))(
        _.serverCatalogStatus
      )
      .optionallyWith(
        serverList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serverList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.GetServersResponse.ReadOnly =
    zio.aws.sms.model.GetServersResponse.wrap(buildAwsValue())
}
object GetServersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.GetServersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.GetServersResponse =
      zio.aws.sms.model.GetServersResponse(
        lastModifiedOn.map(value => value),
        serverCatalogStatus.map(value => value),
        serverList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def lastModifiedOn: Optional[Timestamp]
    def serverCatalogStatus: Optional[zio.aws.sms.model.ServerCatalogStatus]
    def serverList: Optional[List[zio.aws.sms.model.Server.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getLastModifiedOn: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedOn", lastModifiedOn)
    def getServerCatalogStatus
        : ZIO[Any, AwsError, zio.aws.sms.model.ServerCatalogStatus] =
      AwsError.unwrapOptionField("serverCatalogStatus", serverCatalogStatus)
    def getServerList
        : ZIO[Any, AwsError, List[zio.aws.sms.model.Server.ReadOnly]] =
      AwsError.unwrapOptionField("serverList", serverList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.GetServersResponse
  ) extends zio.aws.sms.model.GetServersResponse.ReadOnly {
    override val lastModifiedOn: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedOn())
      .map(value => zio.aws.sms.model.primitives.Timestamp(value))
    override val serverCatalogStatus
        : Optional[zio.aws.sms.model.ServerCatalogStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverCatalogStatus())
        .map(value => zio.aws.sms.model.ServerCatalogStatus.wrap(value))
    override val serverList: Optional[List[zio.aws.sms.model.Server.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sms.model.Server.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sms.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.GetServersResponse
  ): zio.aws.sms.model.GetServersResponse.ReadOnly = new Wrapper(impl)
}
