package zio.aws.sms.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sms.model.primitives.{StackId, StackName, Timestamp}
import scala.jdk.CollectionConverters._
final case class LaunchDetails(
    latestLaunchTime: Optional[Timestamp] = Optional.Absent,
    stackName: Optional[StackName] = Optional.Absent,
    stackId: Optional[StackId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.LaunchDetails = {
    import LaunchDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.LaunchDetails
      .builder()
      .optionallyWith(
        latestLaunchTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestLaunchTime)
      .optionallyWith(
        stackName.map(value => StackName.unwrap(value): java.lang.String)
      )(_.stackName)
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.LaunchDetails.ReadOnly =
    zio.aws.sms.model.LaunchDetails.wrap(buildAwsValue())
}
object LaunchDetails {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sms.model.LaunchDetails] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.LaunchDetails =
      zio.aws.sms.model.LaunchDetails(
        latestLaunchTime.map(value => value),
        stackName.map(value => value),
        stackId.map(value => value)
      )
    def latestLaunchTime: Optional[Timestamp]
    def stackName: Optional[StackName]
    def stackId: Optional[StackId]
    def getLatestLaunchTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("latestLaunchTime", latestLaunchTime)
    def getStackName: ZIO[Any, AwsError, StackName] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.LaunchDetails
  ) extends zio.aws.sms.model.LaunchDetails.ReadOnly {
    override val latestLaunchTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.latestLaunchTime())
      .map(value => zio.aws.sms.model.primitives.Timestamp(value))
    override val stackName: Optional[StackName] = zio.aws.core.internal
      .optionalFromNullable(impl.stackName())
      .map(value => zio.aws.sms.model.primitives.StackName(value))
    override val stackId: Optional[StackId] = zio.aws.core.internal
      .optionalFromNullable(impl.stackId())
      .map(value => zio.aws.sms.model.primitives.StackId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.LaunchDetails
  ): zio.aws.sms.model.LaunchDetails.ReadOnly = new Wrapper(impl)
}
