package zio.aws.sms.model
import zio.aws.sms.model.primitives.{
  ReplicationRunStageProgress,
  ReplicationRunStage
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplicationRunStageDetails(
    stage: Optional[ReplicationRunStage] = Optional.Absent,
    stageProgress: Optional[ReplicationRunStageProgress] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.ReplicationRunStageDetails = {
    import ReplicationRunStageDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.ReplicationRunStageDetails
      .builder()
      .optionallyWith(
        stage.map(value => ReplicationRunStage.unwrap(value): java.lang.String)
      )(_.stage)
      .optionallyWith(
        stageProgress.map(value =>
          ReplicationRunStageProgress.unwrap(value): java.lang.String
        )
      )(_.stageProgress)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.ReplicationRunStageDetails.ReadOnly =
    zio.aws.sms.model.ReplicationRunStageDetails.wrap(buildAwsValue())
}
object ReplicationRunStageDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.ReplicationRunStageDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.ReplicationRunStageDetails =
      zio.aws.sms.model.ReplicationRunStageDetails(
        stage.map(value => value),
        stageProgress.map(value => value)
      )
    def stage: Optional[ReplicationRunStage]
    def stageProgress: Optional[ReplicationRunStageProgress]
    def getStage: ZIO[Any, AwsError, ReplicationRunStage] =
      AwsError.unwrapOptionField("stage", stage)
    def getStageProgress: ZIO[Any, AwsError, ReplicationRunStageProgress] =
      AwsError.unwrapOptionField("stageProgress", stageProgress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.ReplicationRunStageDetails
  ) extends zio.aws.sms.model.ReplicationRunStageDetails.ReadOnly {
    override val stage: Optional[ReplicationRunStage] = zio.aws.core.internal
      .optionalFromNullable(impl.stage())
      .map(value => zio.aws.sms.model.primitives.ReplicationRunStage(value))
    override val stageProgress: Optional[ReplicationRunStageProgress] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stageProgress())
        .map(value =>
          zio.aws.sms.model.primitives.ReplicationRunStageProgress(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.ReplicationRunStageDetails
  ): zio.aws.sms.model.ReplicationRunStageDetails.ReadOnly = new Wrapper(impl)
}
