package zio.aws.sms.model
import scala.jdk.CollectionConverters._
sealed trait ReplicationRunType {
  def unwrap: software.amazon.awssdk.services.sms.model.ReplicationRunType
}
object ReplicationRunType {
  def wrap(
      value: software.amazon.awssdk.services.sms.model.ReplicationRunType
  ): zio.aws.sms.model.ReplicationRunType = value match {
    case software.amazon.awssdk.services.sms.model.ReplicationRunType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sms.model.ReplicationRunType.ON_DEMAND =>
      val r = ON_DEMAND
      r
    case software.amazon.awssdk.services.sms.model.ReplicationRunType.AUTOMATIC =>
      val r = AUTOMATIC
      r
  }
  case object unknownToSdkVersion extends zio.aws.sms.model.ReplicationRunType {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ReplicationRunType =
      software.amazon.awssdk.services.sms.model.ReplicationRunType.UNKNOWN_TO_SDK_VERSION
  }
  case object ON_DEMAND extends zio.aws.sms.model.ReplicationRunType {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ReplicationRunType =
      software.amazon.awssdk.services.sms.model.ReplicationRunType.ON_DEMAND
  }
  case object AUTOMATIC extends zio.aws.sms.model.ReplicationRunType {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ReplicationRunType =
      software.amazon.awssdk.services.sms.model.ReplicationRunType.AUTOMATIC
  }
}
